% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_datastore_duckdb.R
\docType{class}
\name{te_datastore_duckdb-class}
\alias{te_datastore_duckdb-class}
\alias{save_expanded_data,te_datastore_duckdb-method}
\alias{read_expanded_data,te_datastore_duckdb-method}
\alias{sample_expanded_data,te_datastore_duckdb-method}
\title{te_datastore_duckdb, functions and methods}
\usage{
\S4method{save_expanded_data}{te_datastore_duckdb}(object, data)

\S4method{read_expanded_data}{te_datastore_duckdb}(object, period = NULL, subset_condition = NULL)

\S4method{sample_expanded_data}{te_datastore_duckdb}(
  object,
  p_control,
  period = NULL,
  subset_condition = NULL,
  seed
)
}
\arguments{
\item{object}{An object of class \link[=te_datastore-class]{te_datastore} or a child class.}

\item{data}{A data frame containing the expanded trial data. The columns \code{trial_period} and \code{id} are present, which
may be used in methods to save the data in an optimal way, such as with indexes, keys or separate files.}

\item{period}{An integerish vector of non-zero length to select trial period(s) or \code{NULL} (default) to
select all files.}

\item{subset_condition}{A string of length 1 or \code{NULL} (default).}

\item{p_control}{Probability of selecting a control.}

\item{seed}{An integer seed or \code{NULL} (default).}
}
\value{
A 'te_datastore_duckdb' object.
}
\description{
This method is used internally by \link{expand_trials} to save the data to the "datastore" defined in
\link{set_expansion_options}.
}
\section{Slots}{

\describe{
\item{\code{path}}{Path to the duckdb file containing the data.}

\item{\code{table}}{.}

\item{\code{con}}{S4 object of class duckdb_connection.}
}}

\examples{
temp_dir <- tempfile("csv_dir_")
dir.create(temp_dir)
datastore <- save_to_csv(temp_dir)
data(vignette_switch_data)
save_expanded_data(datastore, vignette_switch_data[1:200, ])

# delete after use
unlink(temp_dir, recursive = TRUE)
}
\keyword{internal}
