% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wav.trend.est.R
\name{wav.trend.est}
\alias{wav.trend.est}
\title{Linear Wavelet Thresholding Trend Estimation of Time Series}
\usage{
wav.trend.est(
  x,
  filter.number = 4,
  family = "DaubLeAsymm",
  max.scale = floor(log2(length(x)) * 0.7),
  transform.type = "nondec",
  boundary.handle = FALSE,
  T.CI = FALSE,
  sig.lvl = 0.05,
  lag.max = floor(10 * (log10(length(x)))),
  confint.type = "normal",
  reps = 199,
  spec.est = NULL,
  ...
)
}
\arguments{
\item{x}{The time series you want to estimate the trend function of.}

\item{filter.number}{Selects the index of the wavelet used in the estimation
procedure. For Daubechies compactly supported wavelets the filter number is
the number of vanishing moments.}

\item{family}{Selects the wavelet family to use. Recommended to only use the
Daubechies compactly supported wavelets DaubExPhase and DaubLeAsymm.}

\item{max.scale}{Selects the coarsest scale of the wavelet transform to
analyse to. Should be a value from \eqn{1} (finest) to \eqn{J-1} (coarsest),
where \eqn{n=2^J} is the length of the time series.}

\item{transform.type}{The type of wavelet transform used. Can be \code{"dec"}
which is the standard discrete wavelet transform or \code{"nondec"} (default),
a non-decimated wavelet transform, but a confidence interval
cannot be calculated in this case.}

\item{boundary.handle}{Logical variable. If \code{TRUE}, the time
series is boundary corrected, to get a less variable trend estimate at the
boundaries of the times series. If \code{FALSE}, no boundary correction is applied.}

\item{T.CI}{Logical variable, only to be used if \code{transform.type = TRUE}.
If \code{TRUE}, a \code{(1-sig.lvl)} pointwise confidence interval is
computed for the trend estimate.}

\item{sig.lvl}{Used only if \code{T.CI = TRUE}; a numeric value
(\code{0 <= sig.lvl <= 1}) with which a \code{(1-sig.lvl)} pointwise
confidence interval for the trend estimate is generated.}

\item{lag.max}{Used only if \code{T.CI = TRUE}; a positive integer
specifying the maximum lag to which the local autocovariance function is
estimated.}

\item{confint.type}{Used only if \code{T.CI = TRUE}; the type of confidence
interval computed. Can be \code{"percentile"}, in which case empirical percentiles are used, or
\code{"normal"} (default), in which case the normal approximation is used.}

\item{reps}{Used only if \code{T.CI = TRUE} and \code{transform.type = "dec"} ; the number
of bootstrap replications used to compute the confidence interval.}

\item{spec.est}{Used only if \code{T.CI = TRUE}; the spectrum estimate of the time series,
used to calculate the confidence interval for the trend estimate.}

\item{...}{Further arguments to be passed to the \code{\link{ewspec.trend}} call.}
}
\value{
A \code{list} object containing the following fields:
\item{x}{Input data}
\item{filter.number, family}{Input wavelet parameters}
\item{transform.type, max.scale, boundary.handle, T.CI}{Input parameters}
\item{T}{A vector of length \code{length(x)} containing the trend estimate}
\item{lower.CI}{Returned if \code{T.CI = TRUE}. The lower limit of the pointwise confidence interval}
\item{upper.CI}{Returned if \code{T.CI = TRUE}. The upper limit of the pointwise confidence interval}
\item{sig.lvl}{Returned if \code{T.CI = TRUE}. The significance level of the pointwise confidence interval}
}
\description{
Internal function to compute the linear wavelet thresholding trend estimate for a
time series that may be second-order nonstationary. The function calculates
the wavelet transform of the time series, sets to zero the non-boundary coefficients,
then inverts the transform to obtain the estimate.
This function is not intended for general use by regular users of the package.
}
\references{
McGonigle, E. T., Killick, R., and Nunes, M. (2022). Trend
locally stationary wavelet processes. \emph{Journal of Time Series
Analysis}, 43(6), 895-917.
}
\seealso{
\code{\link{TLSW}}
}
\keyword{internal}
