% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_helpers.R
\name{format_qca_solutions}
\alias{format_qca_solutions}
\title{Format multiple QCA solutions}
\usage{
format_qca_solutions(solutions, var_names, use_tilde = TRUE)
}
\arguments{
\item{solutions}{Character vector. Solution expressions from \code{minimize()}.}

\item{var_names}{Character vector. Variable names used in the analysis.}

\item{use_tilde}{Logical. If TRUE, negation is represented as \code{~VAR}.}
}
\value{
Character vector. Formatted solution expressions.
}
\description{
Formats a vector of solution expressions.
}
\examples{
var_names <- c("KSP", "KPR", "PRD", "RVT", "RCM")
solutions <- c("KSPRVT + RCM", "~KPRPRD")
format_qca_solutions(solutions, var_names)
}
