% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspred.r
\name{predict.tspred}
\alias{predict.tspred}
\title{Predict method for \code{\link{tspred}} objects}
\usage{
\method{predict}{tspred}(object, onestep = obj$one_step, ...)
}
\arguments{
\item{object}{An object of class \code{\link{tspred}} defining a particular time series prediction process.}

\item{onestep}{Should the function produce one-step ahead predictions?
If \code{FALSE}, a multi-step ahead prediction approach is adopted.}

\item{...}{Other parameters passed to the method \code{\link{predict}} of
the \code{\link{modeling}} object from \code{object}.}
}
\value{
An object of class \code{tspred} with updated structure containing
the produced time series predictions.
}
\description{
Obtains predictions for the time series data contained in a \code{\link{tspred}} class object
based on a particular trained model and a prediction method. The model training and prediction method is defined
by a \code{\link{modeling}} object contained in the \code{\link{tspred}} class object.
}
\details{
The function \code{\link{predict.tspred}} calls the method \code{\link{predict}}
on the \code{\link{modeling}} objects for each trained model and time series contained in \code{object}.
Finally, the produced time series predictions are introduced in the structure of the
\code{\link{tspred}} class object in \code{object}.
}
\examples{
\donttest{
data(CATS)

#Obtaining objects of the processing class
proc1 <- subsetting(test_len=20)
proc2 <- BoxCoxT(lambda=NULL)
proc3 <- WT(level=1, filter="bl14")

#Obtaining objects of the modeling class
modl1 <- ARIMA()

#Obtaining objects of the evaluating class
eval1 <- MSE_eval()

#Defining a time series prediction process
tspred_1 <- tspred(subsetting=proc1,
                   processing=list(BCT=proc2,
                                   WT=proc3),
                   modeling=modl1,
                   evaluating=list(MSE=eval1)
)
summary(tspred_1)

tspred_1 <- subset(tspred_1, data=CATS[3])
tspred_1 <- preprocess(tspred_1,prep_test=FALSE)
tspred_1 <- train(tspred_1)
tspred_1 <- predict(tspred_1, onestep=TRUE)
}

}
\seealso{
[tspred()] for defining a particular time series prediction process,
and [ARIMA()] for defining a time series modeling and prediction method.

Other predict: 
\code{\link{predict}()}
}
\author{
Rebecca Pontes Salles
}
\concept{predict}
\keyword{prediction}
\keyword{series}
\keyword{time}
