% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EUNITE.Loads.cont.r
\docType{data}
\name{EUNITE.Loads.cont}
\alias{EUNITE.Loads.cont}
\title{Continuation dataset of the electrical loads of the EUNITE Competition}
\format{
A data frame with 31 observations on the following 48 variables.
\describe{ \item{X00.30}{a numeric vector containing further
observations of \code{X00.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X01.00}{a numeric vector containing further
observations of \code{X01.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X01.30}{a numeric vector containing further
observations of \code{X01.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X02.00}{a numeric vector containing further
observations of \code{X02.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X02.30}{a numeric vector containing further
observations of \code{X02.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X03.00}{a numeric vector containing further
observations of \code{X03.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X03.30}{a numeric vector containing further
observations of \code{X03.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X04.00}{a numeric vector containing further
observations of \code{X04.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X04.30}{a numeric vector containing further
observations of \code{X04.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X05.00}{a numeric vector containing further
observations of \code{X05.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X05.30}{a numeric vector containing further
observations of \code{X05.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X06.00}{a numeric vector containing further
observations of \code{X06.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X06.30}{a numeric vector containing further
observations of \code{X06.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X07.00}{a numeric vector containing further
observations of \code{X07.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X07.30}{a numeric vector containing further
observations of \code{X07.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X08.00}{a numeric vector containing further
observations of \code{X08.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X08.30}{a numeric vector containing further
observations of \code{X08.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X09.00}{a numeric vector containing further
observations of \code{X09.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X09.30}{a numeric vector containing further
observations of \code{X09.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X10.00}{a numeric vector containing further
observations of \code{X10.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X10.30}{a numeric vector containing further
observations of \code{X10.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X11.00}{a numeric vector containing further
observations of \code{X11.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X11.30}{a numeric vector containing further
observations of \code{X11.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X12.00}{a numeric vector containing further
observations of \code{X12.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X12.30}{a numeric vector containing further
observations of \code{X12.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X13.00}{a numeric vector containing further
observations of \code{X13.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X13.30}{a numeric vector containing further
observations of \code{X13.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X14.00}{a numeric vector containing further
observations of \code{X14.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X14.30}{a numeric vector containing further
observations of \code{X14.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X15.00}{a numeric vector containing further
observations of \code{X15.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X15.30}{a numeric vector containing further
observations of \code{X15.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X16.00}{a numeric vector containing further
observations of \code{X16.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X16.30}{a numeric vector containing further
observations of \code{X16.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X17.00}{a numeric vector containing further
observations of \code{X17.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X17.30}{a numeric vector containing further
observations of \code{X17.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X18.00}{a numeric vector containing further
observations of \code{X18.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X18.30}{a numeric vector containing further
observations of \code{X18.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X19.00}{a numeric vector containing further
observations of \code{X19.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X19.30}{a numeric vector containing further
observations of \code{X19.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X20.00}{a numeric vector containing further
observations of \code{X20.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X20.30}{a numeric vector containing further
observations of \code{X20.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X21.00}{a numeric vector containing further
observations of \code{X21.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X21.30}{a numeric vector containing further
observations of \code{X21.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X22.00}{a numeric vector containing further
observations of \code{X22.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X22.30}{a numeric vector containing further
observations of \code{X22.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X23.00}{a numeric vector containing further
observations of \code{X23.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X23.30}{a numeric vector containing further
observations of \code{X23.30} in \code{\link{EUNITE.Loads}} relative to
January 1999.} \item{X24.00}{a numeric vector containing further
observations of \code{X24.00} in \code{\link{EUNITE.Loads}} relative to
January 1999.} }
}
\source{
EUNITE 1999, Electricity Load Forecast using Intelligent Adaptive
Technology: The EUNITE Network Competition. URL:
\url{http://www.eunite.org/knowledge/Competitions/1st_competition/1st_competition.htm}.
}
\usage{
EUNITE.Loads.cont
}
\description{
A dataset of univariate time series providing 31 points beyond the end of
the time series in \code{\link{EUNITE.Loads}} containing half-an-hour
electrical loads measured in January 1999.
}
\details{
Contains the 31 values corresponding to the daily maximum electrical loads
of January 1999 which were to be predicted of \code{\link{EUNITE.Loads}} as
demanded by the EUNITE Competition.
}
\examples{

data(EUNITE.Loads.cont)
str(EUNITE.Loads.cont)
plot(ts(EUNITE.Loads.cont["X24.00"]))

}
\references{
B.-J. Chen, M.-W. Chang, and C.-J. Lin, 2004, Load forecasting
using support vector Machines: a study on EUNITE competition 2001, IEEE
Transactions on Power Systems, v. 19, n. 4 (Nov.), p. 1821-1830.
}
\seealso{
\code{\link{EUNITE.Loads}}, \code{\link{EUNITE.Reg}},
\code{\link{EUNITE.Temp}}
}
\keyword{Competition}
\keyword{EUNITE}
\keyword{Series}
\keyword{Time}
\keyword{datasets}
