% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FanPC_TFM.R
\name{FanPC_TFM}
\alias{FanPC_TFM}
\title{Apply the FanPC method to the Truncated factor model}
\usage{
FanPC_TFM(data, m, A, D, p)
}
\arguments{
\item{data}{A matrix of input data.}

\item{m}{The number of principal components.}

\item{A}{The true factor loadings matrix.}

\item{D}{The true uniquenesses matrix.}

\item{p}{The number of variables.}
}
\value{
A list containing:
\item{AF}{Estimated factor loadings.}
\item{DF}{Estimated uniquenesses.}
\item{MSESigmaA}{Mean squared error for factor loadings.}
\item{MSESigmaD}{Mean squared error for uniquenesses.}
\item{LSigmaA}{Loss metric for factor loadings.}
\item{LSigmaD}{Loss metric for uniquenesses.}
}
\description{
This function performs Factor Analysis via Principal Component (FanPC) on a given data set. It calculates the estimated factor loading matrix (AF), specific variance matrix (DF), and the mean squared errors.
}
\examples{
\dontrun{
library(SOPC)
library(relliptical)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
trnor <- relliptical(n*p,0,1)
epsilon=matrix(trnor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- FanPC_TFM(data, m, A, D, p)
print(results)
}
}
