% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchsubgroup.R
\name{matchsubgroup}
\alias{matchsubgroup}
\title{Screen and collect data of subjects that meet the given conditions}
\usage{
matchsubgroup(
DTSD,
varname,
varvalue
)
}
\arguments{
\item{DTSD}{Object of class DTSD}

\item{varname}{list object;The variable used to screen subjects, and the variables need to be contained in the time-slice data.}

\item{varvalue}{list object;Subjects whose varname variable value equal to \code{varvalue} will be selected}
}
\value{
Returns a DTSD object.
}
\description{
Based on screening criteria, for each specific subject, the data of the observation that meet the
conditions for the first time and the data of subsequent observations in following time slices will be collected.
The data from initial time slice that meet the given conditions to last time slice were then compiled into a new
time-slice dataset, with an aim to create personalized survival path map.
}
\details{
According to the input time, status, variables, subject ID, etc., the data of eligible subjects is screened through specified
given conditions. The subject whose variable data of the first and subsequent time slices are sequentially screened. Once an observation
meet the given condition, data of that observation and the observations in following time slices will be for the subject will be collected.
Data of all subject that meet the criteria will be compiled into a new time-slice dataset. Based on the new dataset, the function returns a
new DTSD object was got. The final returned result contains four list objects: time, state, timeslicedata, subject ID (tspatientid).
}
\examples{
library(dplyr)
data("DTSDHCC")
id = DTSDHCC$ID[!duplicated(DTSDHCC$ID)]
set.seed(123)
id = sample(id,120)
miniDTSDHCC <- DTSDHCC[DTSDHCC$ID \%in\% id,]
dataset = timedivision(miniDTSDHCC,"ID","Date",period = 90,left_interval = 0.5,right_interval=0.5)
resu <- generatorDTSD(dataset,periodindex="time_slice",IDindex="ID" ,timeindex="OStime_day",
 statusindex="Status_of_death",variable =c( "Age", "Amount.of.Hepatic.Lesions",
 "Largest.Diameter.of.Hepatic.Lesions",
 "New.Lesion","Vascular.Invasion" ,"Local.Lymph.Node.Metastasis",
 "Distant.Metastasis" , "Child_pugh_score" ,"AFP"),predict.time=365*1)

varname=list('Amount.of.Hepatic.Lesions')
varvalue=list(1)
df <- matchsubgroup(resu,varname=varname ,varvalue=varvalue)

result <- survivalpath(df,time_slices =4)

}
\author{
Shen Lujun and ZhangTao
}
