% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_standardized_alpha.R
\name{power_standardized_alpha}
\alias{power_standardized_alpha}
\title{Optimizing function to achieve desired power based on a standardized alpha level.}
\usage{
power_standardized_alpha(
  power_function,
  alpha = 0.05,
  power = 0.8,
  standardize_N = 100,
  verbose = Superpower_options("verbose")
)
}
\arguments{
\item{power_function}{Function that outputs the power, calculated with an analytic function.}

\item{alpha}{The unstandardized alpha level (e.g., 0.05), independent of the sample size.}

\item{power}{The desired power, i.e., the outcome of the power calculation you would like to achieve.}

\item{standardize_N}{The sample size you want to use to standardize the alpha level for. Defaults to 100 (based on Good, 1982).}

\item{verbose}{Set to FALSE to not print results (default = TRUE)}
}
\value{
List of 3 objects: a_stan = standardized alpha, N = sample size, and objective = for the weighted combined error rate.
}
\description{
Because the standardized alpha depends on the sample size (N), and the power depends on the sample size, deciding upon the sample size to achieve a desired power requires an iterative procedure. Increasing the sample size reduces the standardized alpha, which requires an increase in the sample size for the power analysis, which reduces the standardized alpha. This function takes a power analysis function that outputs the power as a function of the desired power, the alpha level, as a function of N(x).
}
\section{References}{

Good, I. J. (1982). C140. Standardized tail-area probabilities. Journal of Statistical Computation and Simulation, 16(1), 65–66. <https://doi.org/10.1080/00949658208810607>
}

\examples{
\donttest{
res <- power_standardized_alpha(power_function = "pwr::pwr.t.test(d = 0.3,
n = x, sig.level = a_stan, type = 'two.sample',
alternative = 'two.sided')$power", power = 0.9, alpha = 0.05)
res$N
}
}
