% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkillScore.R
\name{SkillScore}
\alias{SkillScore}
\title{Calculate a skill score and assess uncertainty.}
\usage{
SkillScore(scores, scores.ref, N.eff = NA, score.perf = 0,
  handle.na = c("na.fail", "use.pairwise.complete"))
}
\arguments{
\item{scores}{vector of verification scores}

\item{scores.ref}{vector of verification scores of the reference forecast, must be of the same length as `scores`}

\item{N.eff}{user-defined effective sample size to be used to estimate the sampling uncertainty; if NA, the length of `scores` is used; default: NA}

\item{score.perf}{a numeric constant, indicating the value that the score would assign to the perfect forecast}

\item{handle.na}{how should missing values in scores vectors be handled; possible values are 'na.fail' and 'use.pairwise.complete'; default: 'na.fail'}
}
\value{
vector with skill score and its estimated standard deviation
}
\description{
A skill score is defined as (mean score - mean reference score) / (perfect score - mean reference score). The skill score is zero if the mean score of the forecast equals the mean score of the reference forecast, and equals one if the mean score of the forecast equals the best possible score. Uncertainty is assessed by estimating the standard deviation of the skill score by propagation of uncertainty.
}
\examples{
data(eurotempforecast)
SkillScore(EnsCrps(ens, obs), EnsCrps(ens[, 1:2], obs))
}
\seealso{
ScoreDiff
}
