% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batty_karlstrom_entropy.R
\name{batty}
\alias{batty}
\title{Batty's entropy.}
\usage{
batty(data, category = 1, cell.size = 1, partition = 10, win = NULL)
}
\arguments{
\item{data}{If data are lattice, a data matrix, which can be numeric, factor, character, ...
If the dataset is a point pattern, \code{data} is a \code{ppp} object.}

\item{category}{A single value matching the data category of interest for computing Batty's entropy.
Default to 1. If the dataset is an unmarked point pattern, this argument must not be changed from the default.
In the plot, only data belonging to the selected category are displayed.}

\item{cell.size}{A single number or a vector of length two, only needed if data are lattice. It gives the length of the side of each pixel;
if the pixel is rectangular, the first number gives the horizontal side and the second number gives the vertical side. Default to 1. Ignored if data are points.}

\item{partition}{Input defining the partition into subareas. If an integer, it defines the
number of sub-areas that are randomly generated by \link{areapart}; if a two column matrix
with coordinates, they are the centroids of the subareas built by \link{areapart}. Alternatively,
it can be the output of \link{areapart}, a \code{tess} object built by the user, a \code{list} object
with arguments \code{tiles}, i.e. a list of \code{owin} objects defining the partition, and \code{n}, the number of subareas.
Lastly, it can be an \code{im} object, i.e. a factor- or character-valued pixel image on the
same observation window as the data, so that the partition is defined according to the values
of the image.
The default option is \code{partition=areapart(data, G=10)}, which generates 10 random sub-areas.}

\item{win}{Optional, the observation area given as a \code{owin} object. If
data are a point pattern \code{ppp} object, this argument is ignored
and the observation area is extracted from the object. If data are
given as a matrix, the area should be specified; the default is a
rectangle with x range from 0 to the number of columns of the data, and
y range from 0 to the number of rows of the data.}
}
\value{
A list of five elements:
\itemize{
\item \code{batty} Batty's entropy
\item \code{range} The theoretical range of Batty's entropy
\item \code{rel.batty} Batty's entropy divided by \eqn{\log(\sum Tg)} for comparison across observation areas.
\item \code{areas} a dataframe giving, for each sub-area of the partition, the absolute and relative frequency of
the points/pixels of interest, the sub-area size and the intensity defined as \eqn{pg/Tg}
\item \code{area.tess} a \code{tess} object with the area partition
}
Moreover, a plot is produced showing the data and the area partition.
}
\description{
This function computes Batty's spatial entropy, following Batty (1976), see also Altieri et al (2017 and following)
(references are under the topic \code{\link{SpatEntropy}}).
}
\details{
Batty's spatial entropy measures the heterogeneity in the spatial distribution
of a phenomenon of interest, with regard to an area partition. It is high
when the phenomenon is equally intense over the sub-areas, and low when
it concentrates in one or few sub-areas. This function allows to compute Batty's entropy as
\deqn{H_B=\sum p_g \log(T_g/p_g)}
where \eqn{p_g} is the probability of occurrence of the phenomenon over sub-area \eqn{g},
and \eqn{T_g} is the sub-area size.
When data are categorical, the phenomenon of interest corresponds to
one category, which must be specified. If data are an unmarked
point pattern, a fake mark vector is be created with the same category for all points.
For comparison purposes, the relative version of Batty's entropy is also returned, i.e.
Batty's entropy divided by its maximum \eqn{\log(\sum T_g)}.
Note that when the total observation area is 1, then \eqn{\log(\sum T_g)=0}, therefore
in that case during the computation all \eqn{T_g}s are multiplied by 100 and a warning is produced.
The function is able to work with grids containing missing data, specified as NA values.
All NAs are ignored in the computation.
}
\examples{
#LATTICE DATA

data=matrix((sample(c("a","b","c"), 100, replace=TRUE)), nrow=10)
batty.entropy=batty(data, category="a")

#POINT DATA

#unmarked pp
data=ppp(x=runif(100, 0, 10), y=runif(100, 0, 10), window=square(10))
batty.entropy=batty(data)

#marked pp
data=ppp(x=runif(100, 0, 10), y=runif(100, 0, 10), window=square(10),
         marks=(sample(1:5, 100, replace=TRUE)))
plot(data) #see ?plot.ppp for options
#if you want to compute the entropy on all points
batty.entropy=batty(unmark(data))
#if you want to compute the entropy on a category, say 3
batty.entropy=batty(data, category=3)

}
