% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonTree.R
\name{taxonTree}
\alias{taxonTree}
\title{Create a \code{data.tree} Object from Taxon Names}
\usage{
taxonTree(
  taxon,
  level = c("order", "suborder", "greatgroup", "subgroup"),
  root = "Soil Taxonomy",
  verbose = TRUE,
  special.chars = c("|--", "|", "|", "-"),
  file = "",
  ...
)
}
\arguments{
\item{taxon}{A vector of taxon names}

\item{level}{One or more of: \code{"order"}, \code{"suborder"}, \code{"greatgroup"}, \code{"subgroup"}. The lowest level is passed to \code{getChildLevel()} to generate the leaf nodes.}

\item{root}{Label for root node. Default: \code{"Soil Taxonomy"}; \code{NULL} for "unrooted" tree.}

\item{verbose}{Print tree output? Default: \code{TRUE}}

\item{special.chars}{Characters used to print the tree to console. Default: \code{c("|--", "|", "|", "-")}. For fancy markup try: \code{c("\\u251c","\\u2502", "\\u2514", "\\u2500 ")}}

\item{file}{Optional: path to output file. Default: \code{""} prints to standard output connection (unless redirected by \code{sink()})}

\item{...}{Additional arguments to \code{data.tree::as.Node.data.frame()}}
}
\value{
A \code{SoilTaxonNode} (subclass of \code{data.tree} \code{Node}) object (invisibly). A text representation of the tree is printed to stdout when \code{verbose=TRUE}.
}
\description{
This function takes one or more taxon names and taxonomic levels as input.
}
\details{
A subclass of data.tree \code{Node} object is returned. This object has a custom \code{print()} method
}
\examples{
\dontshow{if (!inherits(requireNamespace("data.tree", quietly = TRUE), 'try-error')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{\}) # examplesIf}

# hapludults and hapludalfs (to subgroup level)
taxonTree(c("hapludults", "hapludalfs"))

# alfisols suborders and great groups
taxonTree("alfisols", root = "Alfisols", level = c("suborder", "greatgroup"))
}
