% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{IsNamedList}
\alias{IsNamedList}
\title{Check List Names}
\usage{
IsNamedList(x, all.unique = TRUE, allow.empty = FALSE, pass.zero = FALSE)
}
\arguments{
\item{x}{A list}

\item{all.unique}{Require that all names are unique from one another}

\item{allow.empty}{Allow empty (\code{nchar = 0}) names}

\item{pass.zero}{Pass on zero-length lists}
}
\value{
\code{TRUE} if ..., otherwise \code{FALSE}
}
\description{
Check to see if a list has names; also check to enforce that all names are
present and unique
}
\examples{
IsNamedList(list())
IsNamedList(list(), pass.zero = TRUE)
IsNamedList(list(1, 2, 3))
IsNamedList(list(a = 1, b = 2, c = 3))
IsNamedList(list(a = 1, 2, c = 3))
IsNamedList(list(a = 1, 2, c = 3), allow.empty = TRUE)
IsNamedList(list(a = 1, a = 2, a = 3))
IsNamedList(list(a = 1, a = 2, a = 3), all.unique = FALSE)

}
\concept{utils}
