% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_list.R
\name{merge_list}
\alias{merge_list}
\title{Merge list of tables on common variable(s)}
\usage{
merge_list(lst)
}
\arguments{
\item{lst}{List of tables to be merged. List object.}
}
\value{
\code{data.table} object
}
\description{
Function that finds a set of common columns in a list of tables, and merges the tables on these columns.
}
\examples{
# Merge list of three tables with different common variables
\dontrun{
A <- data.table::data.table(month=month.name,year=rep(1991:1992,each=12),A=rnorm(24))
B <- data.table::data.table(year=c(1991,1992),B=rbeta(2,1,1))
C <- data.table::data.table(month=month.name,C=runif(12))

out_1 <- merge_list(list(A,B,C))
out_1
}

}
