% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{draw.incompletely.sampled}
\alias{draw.incompletely.sampled}
\title{For a sample with or without unsampled hosts, draw the annotated phylogeny using \code{ggtree}}
\usage{
draw.incompletely.sampled(generator, sample)
}
\arguments{
\item{generator}{A list of class \code{tt.generator} produced by \code{tt.generator}.}

\item{sample}{A list of class \code{tt} produced by \code{sample.tt} or \code{sample.partial.tt}}
}
\value{
A \code{ggtree} object
}
\description{
For a sample with or without unsampled hosts, draw the annotated phylogeny using \code{ggtree}
}
\examples{
generator <- tt.generator(stratus.example.tree, max.unsampled = 2)
samples <- sample.tt(generator, 1, unsampled=2)
# Tree is annotated with the number of unsampled hosts along each branch
draw.incompletely.sampled(generator, samples[[1]])
# This still works if there are no unsampled hosts
samples <- sample.tt(generator, 1)
draw.incompletely.sampled(generator, samples[[1]])
}
