% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_functions.R
\name{BLMM}
\alias{BLMM}
\title{Block length of the missing motif.}
\usage{
BLMM(s, motifLength = 4, returnType = "numeric")
}
\arguments{
\item{s}{a string of either class: 'character' or 'DNAString'.}

\item{motifLength}{the known motif length of the STR region.}

\item{returnType}{the type of return wanted. Takes three values 'numeric', 'string', or 'fullList' (or any other combination cased letters).}
}
\value{
Depending on returnType it return an object of class 'numeric', 'string', or 'fulllist'.
}
\description{
Given a motif length and a string it finds the blocks of the string.
}
\details{
If returnType is 'numeric', the function returns the numeric value of the LUS.
If returnType is instead chosen as 'string', the function returns "[AATG]x" i.e. the motif, AATG, is repeated 'x' times.
Lastly if the returnType is set to fullList, the function returns a list of data.frames containing every possible repeat structure their start and the numeric value of the repeat unit length.
}
\examples{
# Creating compound string 's'
stretch1 <- paste0(rep("AATG", 10), collapse = "")
stretch2 <- paste0(rep("ATCG", 4), collapse = "")

s <- paste0(stretch1, stretch2)

# Return BLMM only
BLMM(s, motifLength = 4, returnType = "numeric")

# Return BLMM and motif of stretch
BLMM(s, motifLength = 4, returnType = "string")

# Return all blocks of 's'
BLMM(s, motifLength = 4, returnType = "fulllist")
}
