% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STR_Region_Identification.R
\name{identifySTRRegions.control}
\alias{identifySTRRegions.control}
\title{Control function for identifySTRRegions}
\usage{
identifySTRRegions.control(colList = NULL, numberOfThreads = 4L,
  reversed = TRUE, includeReverseComplement = TRUE, combineLists = TRUE,
  removeEmptyMarkers = TRUE, matchPatternMethod = "mclapply")
}
\arguments{
\item{colList}{The position of the forward, reverse, and motifLength columns in the flanking region tibble/data.frame. If 'NULL' a function searches for the words 'forward', 'reverse', and 'motif' ot identify the columns.}

\item{numberOfThreads}{The number of threads used by mclapply (stuck at '2' on windows).}

\item{reversed}{TRUE/FALSE: In a revrse complementary run, should the strings/quality be reversed (recommended)?}

\item{includeReverseComplement}{TRUE/FALSE: Should the function also search for the reverse complement DNA strand (recommended)?}

\item{combineLists}{TRUE/FALSE: If 'includeReverseComplement' is TRUE, should the sets be combined?}

\item{removeEmptyMarkers}{TRUE/FALSE: Should markers returning no identified regions be removed?}

\item{matchPatternMethod}{Which method should be used to identify the flanking regions (only 'mclapply' implemented at the moment)?}
}
\value{
A control list setting default behaviour.
}
\description{
A list containing default parameters passed to the \link{identifySTRRegions} function.
}
