% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertical-planning.R
\name{vertical_planning_functions}
\alias{vertical_planning_functions}
\alias{vertical_planning}
\alias{vertical_constant}
\alias{vertical_linear}
\alias{vertical_linear_reverse}
\alias{vertical_block}
\alias{vertical_block_variant}
\alias{vertical_rep_accumulation}
\alias{vertical_set_accumulation}
\alias{vertical_set_accumulation_reverse}
\alias{vertical_undulating}
\alias{vertical_undulating_reverse}
\alias{vertical_volume_intensity}
\title{Vertical Planning Functions}
\usage{
vertical_planning(reps, reps_change = NULL, step = NULL)

vertical_constant(reps, n_steps = 4)

vertical_linear(reps, reps_change = c(0, -1, -2, -3))

vertical_linear_reverse(reps, reps_change = c(0, 1, 2, 3))

vertical_block(reps, step = c(-2, -1, 0, -3))

vertical_block_variant(reps, step = c(-2, -1, -3, 0))

vertical_rep_accumulation(
  reps,
  reps_change = c(-3, -2, -1, 0),
  step = c(0, 0, 0, 0)
)

vertical_set_accumulation(
  reps,
  step = c(-2, -2, -2, -2),
  accumulate_rep = length(reps),
  set_increment = 1
)

vertical_set_accumulation_reverse(
  reps,
  step = c(-3, -2, -1, 0),
  accumulate_rep = length(reps),
  set_increment = 1
)

vertical_undulating(reps, reps_change = c(0, -2, -1, -3))

vertical_undulating_reverse(reps, reps_change = c(0, 2, 1, 3))

vertical_volume_intensity(reps, reps_change = c(0, 0, -3, -3))
}
\arguments{
\item{reps}{Numeric vector indicating reps prescription}

\item{reps_change}{Change in \code{reps} across progression steps}

\item{step}{Numeric vector indicating progression steps (i.e. -3, -2, -1, 0)}

\item{n_steps}{Number of progression steps. Default is 4}

\item{accumulate_rep}{Which rep (position in \code{reps}) to accumulate}

\item{set_increment}{How many sets to increase each step? Default is 1}
}
\value{
Data frame with \code{reps}, \code{index}, and \code{step} columns
}
\description{
Functions for creating vertical planning (progressions)
}
\section{Functions}{
\itemize{
\item \code{vertical_planning}: Generic Vertical Planning

\item \code{vertical_constant}: Constants Vertical Planning

\item \code{vertical_linear}: Linear Vertical Planning

\item \code{vertical_linear_reverse}: Reverse Linear Vertical Planning

\item \code{vertical_block}: Block Vertical Planning

\item \code{vertical_block_variant}: Block Variant Vertical Planning

\item \code{vertical_rep_accumulation}: Rep Accumulation Vertical Planning

\item \code{vertical_set_accumulation}: Set Accumulation Vertical Planning

\item \code{vertical_set_accumulation_reverse}: Set Accumulation Reverse Vertical Planning

\item \code{vertical_undulating}: Undulating Vertical Planning

\item \code{vertical_undulating_reverse}: Undulating Vertical Planning

\item \code{vertical_volume_intensity}: Volume-Intensity Vertical Planning
}}

\examples{
# Generic vertical planning function
# ----------------------------------
# Constant
vertical_planning(reps = c(3, 2, 1), step = c(-3, -2, -1, 0))

# Linear
vertical_planning(reps = c(5, 5, 5, 5, 5), reps_change = c(0, -1, -2))

# Reverse Linear
vertical_planning(reps = c(5, 5, 5, 5, 5), reps_change = c(0, 1, 2))

# Block
vertical_planning(reps = c(5, 5, 5, 5, 5), step = c(-2, -1, 0, -3))

# Block variant
vertical_planning(reps = c(5, 5, 5, 5, 5), step = c(-2, -1, -3, 0))

# Undulating
vertical_planning(reps = c(12, 10, 8), reps_change = c(0, -4, -2, -6))

# Undulating + Block variant
vertical_planning(
  reps = c(12, 10, 8),
  reps_change = c(0, -4, -2, -6),
  step = c(-2, -1, -3, 0)
)

# Rep accumulation
vertical_planning(
  reps = c(10, 8, 6),
  reps_change = c(-3, -2, -1, 0),
  step = c(0, 0, 0, 0)
)
# ----------------------------------

# Constant
vertical_constant(c(5, 5, 5), 4)
vertical_constant(c(3, 2, 1), 2)

# Linear
vertical_linear(c(10, 8, 6), c(0, -2, -4))
vertical_linear(c(5, 5, 5), c(0, -1, -2, -3))

# Reverse Linear
vertical_linear_reverse(c(6, 4, 2), c(0, 1, 2))
vertical_linear_reverse(c(5, 5, 5))

# Block
vertical_block(c(6, 4, 2))

# Block Variant
vertical_block_variant(c(6, 4, 2))

# Rep Accumulation
vertical_rep_accumulation(c(19, 8, 6))

# Set Accumulation
vertical_set_accumulation(c(5, 5, 5))
vertical_set_accumulation(c(3, 2, 1), step = c(-1, -1, -1))
vertical_set_accumulation(
  c(3, 2, 1),
  step = c(-1, -1, -1),
  accumulate_rep = 1
)
vertical_set_accumulation(
  c(3, 2, 1),
  step = c(-1, -1, -1),
  accumulate_rep = 2,
  set_increment = 2
)

# Set Accumulation Reverse
vertical_set_accumulation_reverse(c(5, 5, 5))
vertical_set_accumulation_reverse(c(3, 2, 1), step = c(-1, -1, -1))
vertical_set_accumulation_reverse(
  c(3, 2, 1),
  step = c(-1, -1, -1),
  accumulate_rep = 1
)
vertical_set_accumulation_reverse(
  c(3, 2, 1),
  step = c(-4, -2, 0),
  accumulate_rep = 2,
  set_increment = 2
)

# Undulating
vertical_undulating(c(8, 6, 4))

# Undulating
vertical_undulating_reverse(c(8, 6, 4))

# Volume-Intensity
vertical_volume_intensity(c(6, 6, 6))
}
