% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-scheme.R
\name{plot_scheme}
\alias{plot_scheme}
\title{Plotting of the Set and Reps Scheme}
\usage{
plot_scheme(
  scheme,
  label_size = 3,
  signif_digits = 3,
  adjustment_multiplier = 1
)
}
\arguments{
\item{scheme}{Data Frame create by one of the package functions. See examples}

\item{label_size}{Numeric. Default is 3}

\item{signif_digits}{Rounding numbers for plotting. Default is 3}

\item{adjustment_multiplier}{Factor to multiply the adjustment. Useful when converting to percentage.
Default is 1}
}
\value{
\code{ggplot2} object
}
\description{
Functions for creating \code{ggplot2} plot of the Set and Reps Scheme
}
\examples{
scheme <- scheme_wave(
  reps = c(10, 8, 6, 10, 8, 6),
  # Adjusting sets to use lower \%1RM (RIR Inc method used, so RIR adjusted)
  adjustment = c(4, 2, 0, 6, 4, 2),
  vertical_planning = vertical_linear,
  vertical_planning_control = list(reps_change = c(0, -2, -4)),
  progression_table = progression_RIR_increment,
  progression_table_control = list(volume = "extensive")
)

plot_scheme(scheme)
}
