% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.R
\name{AIC.SSN2}
\alias{AIC.SSN2}
\alias{AIC.ssn_lm}
\alias{AIC.ssn_glm}
\alias{AICc.ssn_lm}
\alias{AICc.ssn_glm}
\title{Compute AIC and AICc of fitted model objects}
\usage{
\method{AIC}{ssn_lm}(object, ..., k = 2)

\method{AIC}{ssn_glm}(object, ..., k = 2)

\method{AICc}{ssn_lm}(object, ..., k = 2)

\method{AICc}{ssn_glm}(object, ..., k = 2)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Optionally more fitted model objects.}

\item{k}{The penalty parameter, taken to be 2. Currently not allowed to differ
from 2 (needed for generic consistency).}
}
\value{
If just one object is provided, a numeric value with the corresponding
AIC or AICc.

If multiple objects are provided, a \code{data.frame} with rows corresponding
to the objects and columns representing the number of parameters estimated
(\code{df}) and the AIC or AICc.
}
\description{
Compute AIC and AICc for one or
several fitted model objects for which a log-likelihood
value can be obtained.
}
\details{
When comparing models fit by maximum or restricted maximum
likelihood, the smaller the AIC or AICc, the better the fit. The AICc contains
a correction to AIC for small sample sizes. AIC and AICc comparisons between \code{"ml"}
and \code{"reml"} models are meaningless -- comparisons should only be made
within a set of models estimated using \code{"ml"} or a set of models estimated
using \code{"reml"}. AIC and AICc comparisons for \code{"reml"} must
use the same fixed effects. To vary the covariance parameters and
fixed effects simultaneously, use \code{"ml"}.

The AIC is defined as
\eqn{-2loglik + 2(npar)} and the AICc is defined as
\eqn{-2loglik + 2n(npar) / (n - npar - 1)}, where \eqn{n} is the sample size
and \eqn{npar} is the number of estimated parameters. For \code{"ml"}, \eqn{npar} is
the number of estimated covariance parameters plus the number of estimated
fixed effects. For \code{"reml"}, \eqn{npar} is the number of estimated covariance
parameters.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
AIC(ssn_mod)
AICc(ssn_mod)
}
