% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQBreg.R
\name{SQBreg}
\alias{SQBreg}
\title{SQBreg}
\usage{
SQBreg(data.train, data.test, y, res, reps, cores, FunKDE, control,
  SQBalgorithm.1, SQBalgorithm.2)
}
\arguments{
\item{data.train}{Training dataset}

\item{data.test}{Testing dataset}

\item{y}{Numeric response variable}

\item{res}{Resampling size. Could not be greater than the input data size.}

\item{reps}{Replicates for the first bagging, default 100}

\item{cores}{Use multi-cores, default one core, use cores='maxcores' for full use.}

\item{FunKDE}{Kernel density estimate function, can use different kernel to fit, default logistic kernel.}

\item{control}{Use in rpart package, rpart.control to tune the control}

\item{SQBalgorithm.1}{Use for the first bagging training. Option: lm, CART(default), knnreg.}

\item{SQBalgorithm.2}{Use for the last bagging training. Option: lm, CART(default), knnreg.}
}
\value{
Given testing set input, make a regression prediction
}
\description{
Do prediction using sequential bagging method with tree based learning algorithm
}
\examples{
data(hills, package="MASS")
rt.df <- hills[sample(nrow(hills)),]
data.train <- rt.df[1 : (length(rt.df[, 1]) / 2), ]
data.test <- rt.df[-(1 : (length(rt.df[, 1]) / 2)),]
fit <- SQBreg(data.train = data.train, data.test = data.test, reps = 50, y = "time")
fit

}
\references{
Breiman L., Friedman J. H., Olshen R. A., and Stone, C. J. (1984)
\emph{Classification and Regression Trees.}

Soleymani, M. and Lee S.M.S(2014). Sequential combination of weighted and nonparametric bagging for classification. \emph{Biometrika}, 101, 2, pp. 491--498.
}
