% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_funcs.R
\name{SSIM}
\alias{SSIM}
\title{Structural similarity index (SSIM).}
\usage{
SSIM(x, y, numBreaks = 256)
}
\arguments{
\item{x}{numeric array. Image 1 color intensity array.}

\item{y}{numeric array. Image 2 color intensity array.}

\item{numBreaks}{numeric. Number of bins for the color histogram.}
}
\value{
value of SSIM defined between 0 and 1.
}
\description{
\code{ssim} returns the value of SSIM between two vectors representing the
color intensities of two images.
}
\details{
SSIM is an image quality measure, given a reference considered as
noise-less image. It can be also used as a perceived similarity measure
between images. The images are converted by default in 8bit.
}
\references{
Wang, Z., Bovik, A. C., Sheikh, H. R., & Simoncelli, E. P. (2004).
Image quality assessment: from error visibility to structural similarity.
IEEE transactions on image processing, 13(4), 600-612.
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
