% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROS.R
\name{ROS}
\alias{ROS}
\title{Random Oversampling (ROS)}
\usage{
ROS(x, y, n_needed = NULL)
}
\arguments{
\item{x}{feature matrix.}

\item{y}{a factor class variable with two classes.}

\item{n_needed}{vector of desired number of synthetic samples for each class.
A vector of integers for each class. Default is NULL meaning full balance.}
}
\value{
a list with resampled dataset.
 \item{x_new}{Resampled feature matrix.}
 \item{y_new}{Resampled target variable.}
}
\description{
Resampling with ROS.
}
\details{
Random Oversampling (ROS) is a method of copying and pasting of positive
samples until balance is achieved.

Can work with classes more than 2.
}
\examples{

set.seed(1)
x <- rbind(matrix(rnorm(2000, 3, 1), ncol = 2, nrow = 1000),
           matrix(rnorm(100, 5, 1), ncol = 2, nrow = 50))
y <- as.factor(c(rep("negative", 1000), rep("positive", 50)))

plot(x, col = y)

# resampling
m <- ROS(x = x, y = y)

plot(m$x_new, col = m$y_new)

}
\author{
Fatih Saglam, saglamf89@gmail.com
}
