% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/S3_Specificity.R
\name{specificity.factor}
\alias{specificity.factor}
\alias{weighted.specificity.factor}
\alias{specificity.cmatrix}
\alias{tnr.factor}
\alias{weighted.tnr.factor}
\alias{tnr.cmatrix}
\alias{selectivity.factor}
\alias{weighted.selectivity.factor}
\alias{selectivity.cmatrix}
\alias{specificity}
\alias{tnr}
\alias{selectivity}
\alias{weighted.specificity}
\alias{weighted.tnr}
\alias{weighted.selectivity}
\title{Specificity}
\usage{
\method{specificity}{factor}(actual, predicted, micro = NULL, na.rm = TRUE, ...)

\method{weighted.specificity}{factor}(actual, predicted, w, micro = NULL, na.rm = TRUE, ...)

\method{specificity}{cmatrix}(x, micro = NULL, na.rm = TRUE, ...)

\method{tnr}{factor}(actual, predicted, micro = NULL, na.rm = TRUE, ...)

\method{weighted.tnr}{factor}(actual, predicted, w, micro = NULL, na.rm = TRUE, ...)

\method{tnr}{cmatrix}(x, micro = NULL, na.rm = TRUE, ...)

\method{selectivity}{factor}(actual, predicted, micro = NULL, na.rm = TRUE, ...)

\method{weighted.selectivity}{factor}(actual, predicted, w, micro = NULL, na.rm = TRUE, ...)

\method{selectivity}{cmatrix}(x, micro = NULL, na.rm = TRUE, ...)

## Generic S3 method
specificity(
 ...,
 micro = NULL,
 na.rm = TRUE
)

## Generic S3 method
tnr(
 ...,
 micro = NULL,
 na.rm = TRUE
)

## Generic S3 method
selectivity(
 ...,
 micro = NULL,
 na.rm = TRUE
)

## Generic S3 method
weighted.specificity(
 ...,
 w,
 micro = NULL,
 na.rm = TRUE
)

## Generic S3 method
weighted.tnr(
 ...,
 w,
 micro = NULL,
 na.rm = TRUE
)

## Generic S3 method
weighted.selectivity(
 ...,
 w,
 micro = NULL,
 na.rm = TRUE
)
}
\arguments{
\item{actual}{A vector of <\link{factor}> values of \link{length} \eqn{n}, and \eqn{k} levels.}

\item{predicted}{A vector of <\link{factor}> values of \link{length} \eqn{n}, and \eqn{k} levels.}

\item{micro}{A <\link{logical}>-value of \link{length} \eqn{1} (default: \link{NULL}). If \link{TRUE} it returns the
micro average across all \eqn{k} classes, if \link{FALSE} it returns the macro average.}

\item{na.rm}{A <\link{logical}> value of \link{length} \eqn{1} (default: \link{TRUE}). If \link{TRUE}, \link{NA} values are removed from the computation.
This argument is only relevant when \code{micro != NULL}.
When \code{na.rm = TRUE}, the computation corresponds to \code{sum(c(1, 2, NA), na.rm = TRUE) / length(na.omit(c(1, 2, NA)))}.
When \code{na.rm = FALSE}, the computation corresponds to \code{sum(c(1, 2, NA), na.rm = TRUE) / length(c(1, 2, NA))}.}

\item{...}{Arguments passed into other methods}

\item{w}{A <\link{numeric}>-vector of \link{length} \eqn{n}. \link{NULL} by default.}

\item{x}{A confusion matrix created \code{\link[=cmatrix]{cmatrix()}}.}
}
\value{
If \code{micro} is \link{NULL} (the default), a named <\link{numeric}>-vector of \link{length} k

If \code{micro} is \link{TRUE} or \link{FALSE}, a <\link{numeric}>-vector of \link{length} 1
}
\description{
A generic funcion for the \href{https://en.wikipedia.org/wiki/Sensitivity_and_specificity}{Specificity}. Use \code{\link[=weighted.specificity]{weighted.specificity()}} for the weighted \href{https://en.wikipedia.org/wiki/Sensitivity_and_specificity}{Specificity}.
\subsection{Other names}{

True Negative Rate, Selectivity
}
}
\section{Creating <\link{factor}>}{


Consider a classification problem with three classes: \code{A}, \code{B}, and \code{C}. The actual vector of \code{\link[=factor]{factor()}} values is defined as follows:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{## set seed
set.seed(1903)

## actual
factor(
  x = sample(x = 1:3, size = 10, replace = TRUE),
  levels = c(1, 2, 3),
  labels = c("A", "B", "C")
)
#>  [1] B A B B A C B C C A
#> Levels: A B C
}\if{html}{\out{</div>}}

Here, the values 1, 2, and 3 are mapped to \code{A}, \code{B}, and \code{C}, respectively. Now, suppose your model does not predict any \code{B}'s. The predicted vector of \code{\link[=factor]{factor()}} values would be defined as follows:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{## set seed
set.seed(1903)

## predicted
factor(
  x = sample(x = c(1, 3), size = 10, replace = TRUE),
  levels = c(1, 2, 3),
  labels = c("A", "B", "C")
)
#>  [1] C A C C C C C C A C
#> Levels: A B C
}\if{html}{\out{</div>}}

In both cases, \eqn{k = 3}, determined indirectly by the \code{levels} argument.
}

\section{Definition}{

Let \eqn{\hat{\sigma} \in [0, 1]} be the proportion of true negatives among the actual negatives. The specificity of the classifier is calculated as,

\deqn{
  \hat{\sigma} = \frac{\#TN_k}{\#TN_k + \#FP_k}
}

Where:
\itemize{
\item \eqn{\#TN_k} is the number of true negatives, and
\item \eqn{\#FP_k} is the number of false positives.
}
}

\examples{
# 1) recode Iris
# to binary classification
# problem
iris$species_num <- as.numeric(
  iris$Species == "virginica"
)

# 2) fit the logistic
# regression
model <- glm(
  formula = species_num ~ Sepal.Length + Sepal.Width,
  data    = iris,
  family  = binomial(
    link = "logit"
  )
)

# 3) generate predicted
# classes
predicted <- factor(
  as.numeric(
    predict(model, type = "response") > 0.5
  ),
  levels = c(1,0),
  labels = c("Virginica", "Others")
)

# 3.1) generate actual
# classes
actual <- factor(
  x = iris$species_num,
  levels = c(1,0),
  labels = c("Virginica", "Others")
)

# 4) evaluate class-wise performance
# using Specificity

# 4.1) unweighted Specificity
specificity(
  actual    = actual,
  predicted = predicted
)

# 4.2) weighted Specificity
weighted.specificity(
  actual    = actual,
  predicted = predicted,
  w         = iris$Petal.Length/mean(iris$Petal.Length)
)

# 5) evaluate overall performance
# using micro-averaged Specificity
cat(
  "Micro-averaged Specificity", specificity(
    actual    = actual,
    predicted = predicted,
    micro     = TRUE
  ),
  "Micro-averaged Specificity (weighted)", weighted.specificity(
    actual    = actual,
    predicted = predicted,
    w         = iris$Petal.Length/mean(iris$Petal.Length),
    micro     = TRUE
  ),
  sep = "\n"
)

}
\seealso{
Other Classification: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{baccuracy.factor}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{entropy.matrix}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fmi.factor}()},
\code{\link{fpr.factor}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mcc.factor}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{recall.factor}()},
\code{\link{roc.auc.matrix}()},
\code{\link{zerooneloss.factor}()}

Other Supervised Learning: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{baccuracy.factor}()},
\code{\link{ccc.numeric}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{entropy.matrix}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fpr.factor}()},
\code{\link{huberloss.numeric}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mcc.factor}()},
\code{\link{mpe.numeric}()},
\code{\link{mse.numeric}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{pinball.numeric}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{rae.numeric}()},
\code{\link{recall.factor}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{roc.auc.matrix}()},
\code{\link{rrmse.numeric}()},
\code{\link{rrse.numeric}()},
\code{\link{rsq.numeric}()},
\code{\link{smape.numeric}()},
\code{\link{zerooneloss.factor}()}
}
\concept{Classification}
\concept{Supervised Learning}
