% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cvSLOPE}
\alias{cvSLOPE}
\title{Tune SLOPE with cross-validation}
\usage{
cvSLOPE(
  x,
  y,
  q = 0.2,
  gamma = 0,
  n_folds = 10,
  n_repeats = 1,
  measure = c("mse", "mae", "deviance", "misclass", "auc"),
  ...
)
}
\arguments{
\item{x}{the design matrix, which can be either a dense
matrix of the standard \emph{matrix} class, or a sparse matrix
inheriting from \link[Matrix:sparseMatrix]{Matrix::sparseMatrix}. Data frames will
be converted to matrices internally.}

\item{y}{the response, which for \code{family = "gaussian"} must be numeric; for
\code{family = "binomial"} or \code{family = "multinomial"}, it can be a factor.}

\item{q}{a vector of quantiles for the \code{q} parameter in SLOPE}

\item{gamma}{relaxation parameter for SLOPE. Default is \code{0.0}, which
implies to relaxation of the penalty.}

\item{n_folds}{number of folds (cross-validation)}

\item{n_repeats}{number of folds (cross-validation)}

\item{measure}{DEPRECATED}

\item{...}{other arguments to pass on to \code{\link[=SLOPE]{SLOPE()}}}
}
\value{
An object of class \code{"TrainedSLOPE"}, with the following slots:
\item{summary}{a summary of the results with means, standard errors,
and 0.95 confidence levels}
\item{data}{the raw data from the model training}
\item{optima}{a \code{data.frame} of the best (mean)
values for the different metrics and their corresponding parameter values}
\item{measure}{a \code{data.frame} listing the used metric and its label}
\item{call}{the call}
}
\description{
This function trains a model fit by \code{\link[=SLOPE]{SLOPE()}} by tuning its parameters
through cross-validation.
}
\examples{
# 8-fold cross-validation
tune <- cvSLOPE(
  subset(mtcars, select = c("mpg", "drat", "wt")),
  mtcars$hp,
  q = c(0.1, 0.2),
  n_folds = 8,
  n_repeats = 2,
  measure = "mse"
)
}
\seealso{
\code{\link[=plot.TrainedSLOPE]{plot.TrainedSLOPE()}}

Other model-tuning: 
\code{\link{plot.TrainedSLOPE}()},
\code{\link{trainSLOPE}()}
}
\concept{model-tuning}
