% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi_logreg_algorithm.R
\name{mi_logreg_algorithm}
\alias{mi_logreg_algorithm}
\title{Main algorithm to calculate mutual information by SLEMI approach}
\usage{
mi_logreg_algorithm(
  data,
  signal = "signal",
  response = "response",
  side_variables = NULL,
  pinput = NULL,
  formula_string = NULL,
  lr_maxit = 1000,
  MaxNWts = 5000,
  model_out = TRUE
)
}
\arguments{
\item{data}{must be a data.frame object. Cannot contain NA values.}

\item{signal}{is a character object with names of columns of dataRaw to be treated as channel's input.}

\item{response}{is a character vector with names of columns of dataRaw  to be treated as channel's output}

\item{side_variables}{(optional) is a character vector that indicates side variables' columns of data, if NULL no side variables are included}

\item{pinput}{is a numeric vector with prior probabilities of the input values. Uniform distribution is assumed as default (pinput=NULL).}

\item{formula_string}{(optional) is a character object that includes a formula syntax to use in logistic regression model. 
If NULL, a standard additive model of response variables is assumed. Only for advanced users.}

\item{lr_maxit}{is a maximum number of iteration of fitting algorithm of logistic regression. Default is 1000.}

\item{MaxNWts}{is a maximum acceptable number of weights in logistic regression algorithm. Default is 5000.}

\item{model_out}{is the logical indicating if the calculated logistic regression model should be included in output list}
}
\value{
a list with three elements:
\itemize{
\item output$mi         - mutual information in bits
\item output$pinput     - prior probabilities used in estimation
\item output$regression - confusion matrix of logistic regression model
\item output$model      - nnet object describing logistic regression model (if model_out=TRUE)
}
}
\description{
Additional parameters: lr_maxit and maxNWts are the same as in definition of multinom function from nnet package. An alternative
model formula (using formula_string arguments) should be provided if  data are not suitable for description by logistic regression
(recommended only for advanced users). It is recommended to conduct estimation by calling mi_logreg_main.R.
}
\section{References}{

[1] Jetka T, Nienaltowski K, Winarski T, Blonski S, Komorowski M,  
Information-theoretic analysis of multivariate single-cell signaling responses using SLEMI,
\emph{PLoS Comput Biol}, 15(7): e1007132, 2019, https://doi.org/10.1371/journal.pcbi.1007132.
}

\examples{
## Estimate mutual information directly
temp_data=data_example1
output=mi_logreg_algorithm(data=data_example1,
                   signal = "signal",
                   response = "response")

}
