% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arimaSpec.R
\name{arimaSpec}
\alias{arimaSpec}
\title{Automatic Modeling of a Scalar Non-Seasonal Time Series}
\usage{
arimaSpec(
  zt,
  maxorder = c(5, 1, 4),
  criterion = "bic",
  output = FALSE,
  method = "CSS-ML",
  pv = 0.01
)
}
\arguments{
\item{zt}{T by 1 vector of an observed scalar time series without missing values.}

\item{maxorder}{Maximum order of \eqn{(p,d,q)} where \eqn{p} is the AR order, \eqn{d} the degree of differencing,
and \eqn{q} the MA order. Default value is (5,1,4).}

\item{criterion}{Information criterion used for model selection. Either AIC or BIC. Default is "bic".}

\item{output}{If TRUE it returns the differencing order, the selected order and the minimum
value of the criterion. Default is TRUE.}

\item{method}{Estimation method. See the arima command in R. Possible values are "CSS-ML", "ML", and "CSS".
Default is "CSS-ML".}

\item{pv}{P-value for unit-root test. Default is 0.01.}
}
\value{
A list containing:
\itemize{
   \item order - Regular ARIMA order.
   \item crit - Minimum criterion.
   \item include.mean - Switch about including mean in the model.
}
}
\description{
Select an ARIMA model for a non-seasonal scalar time series. It uses augmented Dickey-Fuller
(ADF) test to check for unit roots.
The maximum degree of differencing is 2.
}
\details{
Find the AR order by checking a pure AR model for the differenced series.
The maximum AR order tried is min(default AR order and the order of pure AR model).
Check the MA order by checking pure MA model using rank-based Ljung-Box statistics.
The maximum MA order tried is the min(default MA order and the order of pure MA model).
Finally, sequentially decreasing the AR order and increasing the MA order to obtain
best models using the specified criterion function.
}
\examples{
data(TaiwanAirBox032017)
fit <- arimaSpec(as.matrix(TaiwanAirBox032017[,1]))

}
