% Generated by roxygen2 (4.0.2): do not edit by hand
\name{clustfun}
\alias{clustfun}
\title{Clustering function}
\usage{
clustfun(x, r, correction = "border", scaled = FALSE, ...)
}
\arguments{
\item{x}{Point pattern}

\item{r}{Vector of distances}

\item{correction}{Border correction. "none" or "border" (reduced window) supported.}

\item{scaled}{Scale with theoretical value? Should be done afterwards.}

\item{...}{ignored.}
}
\value{
\code{\link{fv}}-object, see \link{spatstat} for more.
}
\description{
Summarise the amount of local connectivity in a stationary and isotropic point pattern (2/3d).
}
\details{
This is a generalisation of the clustering coefficient by Watts and Strogatz 1998.

Reduced border correction available.
}
\examples{
\dontrun{
en <- envelope(rcell(nx=15), fun=clustfun)
plot(en)
}
}

