% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_pValue.R
\name{block_test}
\alias{block_test}
\title{Block test for structural changes}
\usage{
block_test(x, s, fun = "gmd", varEstim = var)
}
\arguments{
\item{x}{times series or random field to be tested. Either a numeric vector or a numeric matrix.}

\item{s}{parameter for the size of the blocks, 0.5 < s < 1, block length \eqn{l_n = [n^s]}. Default is \code{\link{sOpt}}\code{(n, 0.6)}.}

\item{fun}{Character string; one of "gmd" (default), "var", "jb", "grubbs", "ANOVA", "ad", "sw" (see \code{\link{block_stat}} for details).}

\item{varEstim}{variance estimator or variance estimation of the whole field or times series.
Either a function to estimate the variance with, or a numeric value.}
}
\value{
A list of the class "htest" containing the following components:
\item{statistic}{value of the test statistic (numeric).}
\item{p.value}{p-value (numeric).}
\item{alternative}{alternative hypothesis (character string).}
\item{method}{name of the performed test (character string).}
\item{data.name}{name of the data (character string).}
}
\description{
A test to detect whether an underlying time series or random field is stationary (hypothesis)
or if there is a location shift present in a region (alternative).
}
\examples{
# time series with a shift 
x <- arima.sim(model = list(ar = 0.5), n = 100)
x[1:50] <- x[1:50] + 1
block_test(x, sOpt(100, 0.6))

# field without a shift and ordinary variance
X <- genField(c(50, 50))
block_test(X, sOpt(50, 0.6), "var")

# field with a shift and ordinary variance
X <- genField(c(50, 50), type = 2)
block_test(X, sOpt(50, 0.6), "var")

#' # GMD test statistic, scaling variance estimated by the mad
block_stat(X, 0.6, fun = "var", varEstim = mad)

}
\references{
\enc{Görz}{Goerz}, S. and Fried, R. (2025). "Detecting changes in the mean of spatial random fields on a regular grid", \emph{arXiv preprint} \href{https://arxiv.org/abs/2512.11599}{arXiv:2512.11599}

Schmidt, S. K. (2024). Detecting changes in the trend function of heteroscedastic time series. Bernoulli, 30(4), 2598-2622.
}
\seealso{
\link{block_stat}, \link{block_pValue}
}
