% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_sar.R
\name{item_predict}
\alias{item_predict}
\title{Get item-to-item recommendations from a SAR model}
\usage{
item_predict(object, items, k = 10)
}
\arguments{
\item{object}{A SAR model object.}

\item{items}{A vector of item IDs.}

\item{k}{The number of recommendations to obtain.}
}
\value{
A data frame containing one row per item ID supplied.
}
\description{
Get item-to-item recommendations from a SAR model
}
\examples{

data(ms_usage)
mod <- sar(ms_usage)

# item recomendations for a set of item IDs
items <- unique(ms_usage$item)[1:5]
item_predict(mod, items=items)

}
