% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SACOBRA.R
\name{plog}
\alias{plog}
\title{Monotonic transform}
\usage{
plog(y, pShift = 0)
}
\arguments{
\item{y}{function argument}

\item{pShift}{shift}
}
\value{
\eqn{plog(y)}
}
\description{
The function is introduced in [Regis 2014] and extended here by a parameter \eqn{p_{shift}}.
It is used to squash functions with a large range into a smalller range.\cr
Let \eqn{y' = (y-p_{shift})}: 
 \deqn{ plog(y) =  \ln(1+ y'), \quad\mbox{if}\quad y' \ge 0 } 
 \deqn{ plog(y) = -\ln(1- y'), \quad\mbox{if}\quad y'  <   0 }
}
\seealso{
\code{\link{plogReverse}}
}
