% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_cov_adj.R
\name{derived_outcome_vals}
\alias{derived_outcome_vals}
\alias{h_derived_outcome_vals}
\alias{h_strat_derived_outcome_vals}
\title{Derive Outcome Values Based on Log Hazard Ratio}
\usage{
h_derived_outcome_vals(
  theta,
  df,
  treatment,
  time,
  status,
  covariates,
  n = nrow(df)
)

h_strat_derived_outcome_vals(
  theta,
  df,
  treatment,
  time,
  status,
  strata,
  covariates
)
}
\arguments{
\item{theta}{(\code{number}) The assumed log hazard ratio of the second vs. the first level of the
treatment arm variable.}

\item{df}{(\code{data.frame}) The data frame containing the survival data.}

\item{treatment}{(\code{string}) The name of the treatment arm variable in \code{df}. It should be a factor with
two levels, where the first level is the reference group.}

\item{time}{(\code{string}) The name of the time variable in \code{df}, representing the survival time.}

\item{status}{(\code{string}) The name of the status variable in \code{df}, with 0 for censored and 1 for event.}

\item{covariates}{(\code{character}) The column names in \code{df} to be used for covariate adjustment.}

\item{n}{(\code{count}) The number of observations. Note that this can be higher than the number of rows
when used in stratified analyses computations.}

\item{strata}{(\code{string}) The name of the strata variable in \code{df}, which must be a factor.}
}
\value{
A data frame containing the same data as the input \code{df}, but restructured with standardized column names
\code{index}, \code{treatment}, \code{time}, \code{status}, the covariates, and an additional column \code{O_hat} containing the
derived outcome values. For the stratified version, the list of data frames is returned, one for each stratum.
}
\description{
Compute the derived outcome values based on a given log hazard ratio.
}
\details{
Please note that the \code{covariates} must not include \code{index}, \code{treatment}, \code{time}, \code{status}
to avoid naming conflicts.
}
\section{Functions}{
\itemize{
\item \code{h_derived_outcome_vals()}: calculates the derived outcome values for the overall data set.

\item \code{h_strat_derived_outcome_vals()}: calculates the derived outcome values for each stratum separately.

}}
\keyword{internal}
