% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_test_disc.R
\name{chi_test_disc}
\alias{chi_test_disc}
\title{This function performs a number of chi-square gof tests for continuous data}
\usage{
chi_test_disc(
  x,
  pnull,
  phat = function(x) -99,
  nbins = c(50, 10),
  rate = 0,
  minexpcount = 5,
  ChiUsePhat = TRUE,
  allbins
)
}
\arguments{
\item{x}{data set}

\item{pnull}{cdf under the null hypothesis}

\item{phat}{=function(x) -99, function to estimate parameters, or starting values of multi-D minimum chi square minimization, or -99 if no parameters are estimated}

\item{nbins}{=c(50, 10) number of bins for chi-square tests}

\item{rate}{=0, rate of Poisson if sample size is random}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{= TRUE, if TRUE param is estimated parameter, otherwise minimum chi square method is used.}

\item{allbins}{set of bins to use}
}
\value{
A numeric matrix of test statistics, degrees of freedom and p.values
}
\description{
This function performs a number of chi-square gof tests for continuous data
}
