#' Annotation profiles of 116 gut prevalent species
#' 
#' A dataset containing the the KEGG orthology annotation profiles of 116 gut 
#' prevlent species which was downloaded from the Integrated Microbial Genomes 
#' (IMG).
#' 
#' @details  This dataset focused on a list of 116 prevalent gut species, whose 
#'   genome sequence is available in IMG database and sequence coverage is more 
#'   than 1% in at least one metagenomic sample of 124 individuals. Genome and 
#'   annotation profiles of this 116 species was collected from IMG database.
#'   
#'   With a in-house R script, we obtained genomic data for all organisms from
#'   the Department of Integrated Microbial Genomes project (IMG). For each
#'   species, the list of genes mapped to the Kyoto Encyclopedia of Genes and
#'   Genomes orthologous groups (KEGG KOs) was downloaded. For more annotation 
#'   information on these species, see \url{img.jgi.doe.gov/}.


#' @format A list with 116 elements and each elements represents the annotation
#'   profile of the species
#'   
#' @source \url{img.jgi.doe.gov/}
#'   
#' @name gut_microbiome
NULL