% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGG.R
\name{EGG}
\alias{EGG}
\title{The four parameter Exponentiated Generalized Gamma family}
\usage{
EGG(mu.link = "log", sigma.link = "log", nu.link = "log", tau.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu parameter.}

\item{tau.link}{defines the tau.link, with "log" link as the default for the tau parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a EGG distribution in the \code{gamlss()} function.
}
\description{
The four parameter Exponentiated Generalized Gamma distribution
}
\details{
Four parameter Exponentiated Generalized Gamma distribution with parameters \code{mu}, 
\code{sigma}, \code{nu} and \code{tau} has density given by

\eqn{f(x) = \frac{\nu \sigma}{\mu \Gamma(\tau)} \left(\frac{x}{\mu}\right)^{\sigma \tau -1} \exp\left\{ - \left( \frac{x}{\mu} \right)^\sigma \right\} \left\{ \gamma_1\left( \tau, \left( \frac{x}{\mu} \right)^\sigma \right) \right\}^{\nu-1} ,}

for x > 0.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma, nu and tau
\donttest{
y <- rEGG(n=500, mu=0.1, sigma=0.8, nu=10, tau=1.5)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, tau.fo=~1, 
              family='EGG',
              control=gamlss.control(n.cyc=500, trace=FALSE))

# Extracting the fitted values for mu, sigma, nu and tau
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))
exp(coef(mod, what='nu'))
exp(coef(mod, what='tau'))
}

# Example 2
# Generating random values under some model
\donttest{
n <- 200
x1 <- runif(n, min=0.2, max=0.8)
x2 <- runif(n, min=0.2, max=0.8)
mu <- exp(-0.8 + -3 * x1)
sigma <- exp(0.77 - 2 * x2)
nu <- 10
tau <- 1.5
y <- rEGG(n=n, mu, sigma, nu, tau)

mod <- gamlss(y~x1, sigma.fo=~x2, nu.fo=~1, tau.fo=~1, family=EGG,
              control=gamlss.control(n.cyc=500, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
exp(coef(mod, what="nu"))
exp(coef(mod, what="tau"))
}
}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{cordeiro2011}{RelDists}
}
\seealso{
\link{dEGG}
}
\author{
Amylkar Urrea Montoya, \email{amylkar.urrea@udea.edu.co}
}
