% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSSSC.R
\name{measureMNCut}
\alias{measureMNCut}
\title{Multiple Normalized Cut}
\usage{
measureMNCut(sim, label)
}
\arguments{
\item{sim}{similarity matrix.}

\item{label}{vector of labels.}
}
\value{
MNCut Multiple Normalized Cut value.
}
\description{
Calculate the Multiple Normalized Cut value from a similarity matrix.
}
\details{
measureMNCut returns the Multiple Normalized Cut value
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
           
sim <- computeGaussianSimilarity(dat, 1)

ML <- list(c("10","20"),  c("60","70"))
CNL <- list(c("30","80"), c("90","120"))

res <- KwaySSSC(sim, K=0, list.ML=ML, list.CNL=CNL)

measureMNCut(sim, res$label)

}
\keyword{internal}
