% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{addIds2Sampling}
\alias{addIds2Sampling}
\title{Adding Ids To a Sampling}
\usage{
addIds2Sampling(sampling, toAdd = NULL)
}
\arguments{
\item{sampling}{object of a data sample.}

\item{toAdd}{vector of ids to add.}
}
\value{
The completed sampling object.
}
\description{
adds some observations to set of sampled observations.
}
\details{
addIds2Sampling adds some observations to set of sampled observations.
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf)

res.sampling <- computeSampling(x$features$initial$x)
completed.sampling <- addIds2Sampling(res.sampling, rownames(x$features$initial$x[1:5,,drop=FALSE]))


}
\keyword{internal}
