% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSpectral.R
\name{computeGaussianSimilarityZP}
\alias{computeGaussianSimilarityZP}
\title{Gaussian similarity}
\usage{
computeGaussianSimilarityZP(dat, k = 7)
}
\arguments{
\item{dat}{numeric matrix of data (point by line).}

\item{k}{number of neighbour for the computation of local sigma (smooth parameter of Gaussian kernel).}
}
\value{
sim similarity matrix.
}
\description{
Compute a similarity matrix thanks a Gaussian kernel for which the parameters are self-tuned (according to Zelnik-Manor and Perona, 2004).
}
\details{
computeGaussianSimilarityZP returns a similarity matrix computed thanks a Gaussian kernel for which the parameters are self-tuned (according to Zelnik-Manor and Perona, 2004)
}
\examples{
require(grDevices)

dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))

sim <- computeGaussianSimilarityZP(dat, 10)

pal <- colorRampPalette(c("blue", "red"))
image(sim, col = pal(10))
}
\references{
L. Zelnik-Manor, P. Perona, Self tuning spectral clustering, Adv. Neural Inf. Process. Systems (2004), pp. 1601-1608.
}
\seealso{
\code{\link{computeGaussianSimilarity}}
}
\keyword{internal}
