% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_annual_peak_error.R
\name{rvn_annual_peak_error}
\alias{rvn_annual_peak_error}
\title{Annual Peak Errors}
\usage{
rvn_annual_peak_error(
  sim,
  obs,
  mm = 9,
  dd = 30,
  add_line = TRUE,
  add_labels = TRUE
)
}
\arguments{
\item{sim}{time series object of simulated flows}

\item{obs}{time series object of observed flows}

\item{mm}{month of water year (default 9)}

\item{dd}{day of water year (default 30)}

\item{add_line}{optionally adds a 1:1 line to the plot for reference
(default \code{TRUE})}

\item{add_labels}{optionally adds labels for overpredict/underpredict on
right side axis (default \code{TRUE})}
}
\value{
returns a list with peak errors in a data frame, and a ggplot object
 \item{df_peak_error}{data frame of the calculated peak errors}
 \item{p1}{ggplot object with plotted annual peak errors}
}
\description{
rvn_annual_peak_error creates a plot of the annual observed and simulated peak
percent errors, based on the water year.
}
\details{
Creates a plot of the percent errors in simulated peaks for
each water year. The peaks are calculated as the magnitude of the largest
event in each water year. Note that the rvn_annual_peak_error function is first
used to obtain the peaks in each year, then the percent errors are
calculated.

The percent errors are calculated as (QPsim-QPobs)/QPobs*100, where QP is
the peak flow event.

The sim and obs should be of time series (xts) format and are assumed to be
of the same length and time period. The flow series are assumed to be daily
flows with units of m3/s.

The add_labels will add the labels of 'overprediction' and 'underprediction'
to the right hand side axis if set to TRUE. This is useful in interpreting
the plots.

Note that a plot title is purposely omitted in order to allow the automatic
generation of plot titles.
}
\examples{

system.file("extdata","run1_Hydrographs.csv", package="RavenR") \%>\%
rvn_hyd_read(.) \%>\%
rvn_hyd_extract(subs="Sub36",.) ->
hyd_data

sim <- hyd_data$sim
obs <- hyd_data$obs

# create a plot of annual peak errors with default options
peak1 <- rvn_annual_peak_error(sim, obs)
peak1$df_peak_error
peak1$p1

# plot directly and without labels
rvn_annual_peak_error(sim, obs, add_line=TRUE, add_labels=FALSE)

}
\seealso{
\code{\link{rvn_annual_peak_event}} to consider the timing of peak
events \code{\link{rvn_annual_peak_event_error}} to calculate errors in peak
events.
}
