% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVPedigree.R
\name{RVPedigree}
\alias{RVPedigree}
\title{RVPedigree main function}
\usage{
RVPedigree(method = "ASKAT", y = NULL, X = NULL, Phi = NULL,
  filename = NULL, type = "bed", regions = NULL, weights = NULL,
  Nperm = 100, pvalThreshold = 0.1, VCC3afterVCC1 = FALSE, Ncores = 1)
}
\arguments{
\item{method}{character, selects the method to use for the
    association testing. Can be one of the following:
\itemize{
\item \code{"ASKAT"} (default)
\item \code{"NASKAT"}, normalized ASKAT
\item \code{"VCC1"}, VC-C1
\item \code{"VCC2"}, VC-C2
\item \code{"VCC3"}, VC-C3
}}

\item{y}{vector of phenotype data (one entry per individual), of
length \eqn{n}.}

\item{X}{matrix of covariates including intercept (dimension:
\eqn{n \times p}, with \eqn{p} the number of covariates)}

\item{Phi}{Relationship matrix (i.e. twice the kinship matrix); an
\eqn{n \times n} square symmetric positive-definite matrix.}

\item{filename}{character, path to input file containing haplotype data}

\item{type}{character, \code{'ped'}, \code{'bed'} (default) or
\code{'shapeit-haps'} format of input file containing haplotype
data}

\item{regions}{a data frame with details of the genomic regions in
which the association test specified by the \code{method}
parameter should be run. The data frame should have one row
per region and (at least) four columns with the following
names:
\itemize{
\item \code{Name}: Name of the region (e.g. \code{Gene 01})
\item \code{Chr}: Chromosome on which the region is located.
\item \code{StartPos}: The base pair coordinate at which the
region starts
\item \code{EndPos}: The base pair coordinate at which the
region ends.
}
Any other columns will be ignored.}

\item{weights}{optional numeric vector of genotype weights. If
this option is not specified, the beta distribution is used
for weighting the variants, with each weight given by
\eqn{w_i = dbeta(f_i, 1, 25)^2}, with \eqn{f_i} the minor
allele frequency (MAF) of variant \eqn{i}. This default is the
same as used by the
\href{https://cran.r-project.org/package=SKAT}{\code{SKAT}
package}. This vector is used as the diagonal of the
\eqn{m \times m} matrix \eqn{W}, with \eqn{m} the number of
variants.}

\item{Nperm}{(integer) The number of permutations to be done to
calculate the empirical p-value if the VCC2 or VCC3 method is
used. For other methods this parameter is ignored (default:
100).}

\item{pvalThreshold}{(numeric) Threshold for the association
p-value. Regions with a p-value below this threshold will not
be present in the output data frame (default: 0.1).}

\item{VCC3afterVCC1}{(logical) Boolean value that indicates
whether the VC-C3 method should automatically be run on the
variants passing the p-value threshold set using the
\code{pvalThreshold} parameter (default: FALSE).}

\item{Ncores}{(integer) Number of processor (CPU) cores to be used
in parallel when doing running the association analysis. If
the number of regions is larger than the number of cores, then
each region gets to use maximum one core. If the number of
cores is larger than the number of regions and the VCC2 or
VCC3 methods are selected, the remaining cores are distributed
among the regions to parallelize the permutations used to
determine the p-value (default: 1).}
}
\value{
A data frame containing results of the association test
    specified by the \code{method} parameter for each region in
    the data frame specified by the \code{regions} parameter. The
    output data frame contains the following columns:
    \itemize{
    \item \code{Score.Test}: the score of the given association test
    \item \code{P.value}: the p-value of the association test
    \item \code{N.Markers}: the number of markers in the region
    \item \code{regionname}: Name of the regions/genes on which you
    are running the association tests
    }
    Note that regions that do not contain any genetic variants
    will be removed from the output.
}
\description{
Main function of the RVPedigree package
}
\details{
The RVPedigree function is the main function of the RVPedigree
used package.

Under the hood this function calls \code{\link{ASKAT.region}},
    \code{\link{NormalizedASKAT.region}},
    \code{\link{VCC1.region}}, \code{\link{VCC2.region}} or
    \code{\link{VCC3.region}}, depending on the \code{method}
    parameter specified by the user.
}
\author{
Lennart C. Karssen
}

