% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetCrs.R
\name{SetCrs}
\alias{SetCrs}
\title{GUI: Coordinate Reference System}
\usage{
SetCrs(crs = sp::CRS(as.character(NA)), parent = NULL)
}
\arguments{
\item{crs}{CRS.
Coordinate reference system described using PROJ.4 arguments.}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Returns an updated value of the \code{crs} argument.
}
\description{
A graphical user interface (\acronym{GUI}) for specifying PROJ.4 arguments
associated with a coordinate reference system (CRS).
The arguments must be entered exactly as in the PROJ.4 documentation,
in particular there cannot be any white space in +<arg>=<value> strings,
and successive such strings can only be separated by blanks.
}
\examples{
\dontrun{
  SetCrs("+init=epsg:4326")
}

}
\seealso{
\code{\link[sp]{CRS}}, \code{\link[rgdal]{checkCRSArgs}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
