% Generated by roxygen2 (4.0.2): do not edit by hand
\name{tp}
\alias{tp}
\title{True prevalence}
\usage{
tp(x, n, se, sp, type = "blaker", conf = 0.95)
}
\arguments{
\item{x}{number of positive units (scalar)}

\item{n}{sample size (no. units sampled) (scalar)}

\item{se}{test sensitivity (scalar)}

\item{sp}{test specificity (scalar)}

\item{type}{method for estimating CI, one of c("normal", "c-p", "sterne", "blaker", "wilson", "all")}

\item{conf}{desired level of confidence for CI, default = 0.95 (scalar)}
}
\value{
list with 2 elements, a matrix of apparent prevalence and
  lower and upper confidence limits
  and a matrix of true prevalence and lower and upper
  confidence limits using the chosen method(s)
}
\description{
Estimates true prevalence and confidence limits for
given sample size and result, according to specified method
}
\examples{
# examples for tp
x<- 20
n<- 120
se<- 0.9
sp<- 0.99
conf<- 0.95
tp(x, n, se, sp, "all")
tp(x, n, se, sp, "c-p")
tp(x, n, 0.95, 0.9, "c-p")
}
\keyword{methods}

