% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_get_medians.R
\name{get_medians}
\alias{get_medians}
\alias{get_credible_interval}
\alias{get_relative_precision}
\title{Generate medians, credible intervals, and relative precisions}
\usage{
get_medians(sample)

get_credible_interval(sample, perc_ci = 0.95)

get_relative_precision(medians, ci)
}
\arguments{
\item{sample}{array of samples generated by \code{load_samples}.}

\item{perc_ci}{Number from 0 to 1. Determines width of credible interval.}

\item{medians}{Array of medians generated from samples.}

\item{ci}{Credible interval generated by \code{get_credible_interval()}.}
}
\value{
An \code{array} of estimates/credible intervals/relative precisions.
}
\description{
\code{get_medians()} generates median estimates for array of samples loaded from \code{load_samples()}.

\code{get_credible_interval()} generates the credible interval of each estimate using samples loaded from \code{load_samples()}.

\code{get_relative_precision()} generates the relative precision of each estimate using samples loaded from \code{load_samples()}. The relative precision for an estimate is defined as the ratio of the estimate's median divided by the width of its credible interval.
}
\examples{
minmedians <- get_medians(minsample)
minci <- get_credible_interval(minsample)
# Reducing perc_ci narrows the credible interval
minci_75 <- get_credible_interval(minsample, perc_ci = 0.75)
# low relative precision due to small data size
minrp <- get_relative_precision(minmedians, minci)
# reducing CI increases relative precision
minrp_75 <- get_relative_precision(minmedians, minci_75)
# find estimates with low relative precision
low_rp <- minrp_75 < 1
}
