% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotland.R
\name{plotland}
\alias{plotland}
\title{Plot landmarks importance on 3d mesh}
\usage{
plotland(pca,sel=1,refsur=NULL,refmat=NULL,k=5,pal=NULL,
  defo=FALSE,radius=0.001)
}
\arguments{
\item{pca}{the result of a relative warp analysis. Classes \code{relwarps} and
\code{nosymproc} are supported.}

\item{sel}{numeric indicating the focal RW/PC axis.}

\item{refsur}{the \code{mesh3d} object to plot on. If \code{NULL}, the mesh
is reconstructed by means of \code{\link[Rvcg]{vcgBallPivoting}} from the consensus
configuration derived from \code{pca}.}

\item{refmat}{the landmark set related to \code{refsur}. If \code{NULL},
the consensus configuration derived from \code{pca} is used.}

\item{k}{the argument \code{k} passed to \code{\link{interpolMesh}}.}

\item{pal}{a vector of colors to be passed to \code{\link[grDevices]{colorRampPalette}}.}

\item{defo}{when \code{refsur} and \code{refmat} are provided, \code{defo = TRUE}
warps \code{refsur} on the consensus shape.}

\item{radius}{argument \code{radius} passed to \code{\link[rgl]{spheres3d}}}
}
\value{
A list including a \code{mesh3d} object colored according to landmarks
  importance and a matrix of landmarks importance on each RW/PC axis. Additionally,
  the function returns a 3d plot of the mesh.
}
\description{
The function relates PCA loadings of a single PC axis to
  individual landmarks and plots them on a 3d mesh by means of interpolation.
}
\examples{
  \donttest{
  da<-"https://github.com/pasraia/RRmorph_example_data/raw/refs/heads/main/RRmorphdata.rda"
  download.file(url=da,destfile = paste0(tempdir(),"/RRmorphdata.rda"))
  load(paste0(tempdir(),"/RRmorphdata.rda"))

  require(rgl)
  require(Morpho)

  pca<-procSym(endo.set)
  ldm<-endo.set[,,"Homo_sapiens"]
  sur<-endo.sur[["Homo_sapiens"]]

  plotland(pca=pca,sel=1,refsur = sur,refmat = ldm)
  }
}
\author{
Marina Melchionna, Silvia Castiglione, Carmela Serio, Giorgia Girardi
}
