% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{log_reg}
\alias{log_reg}
\title{log_reg}
\usage{
log_reg(
  data,
  sel.Gene = "all",
  group.study,
  group.ref,
  increment,
  centerline = 1,
  ci = 0.95,
  p.adjust = FALSE,
  p.adjust.method = "BH",
  log.axis = FALSE,
  x.axis.title = "Odds ratio",
  y.axis.title = "",
  axis.title.size = 11,
  axis.text.size = 10,
  legend.title = "p value",
  legend.text.size = 11,
  legend.title.size = 11,
  legend.position = "right",
  plot.title = "",
  plot.title.size = 14,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "OR_plot",
  save.to.txt = FALSE,
  name.txt = "OR_results"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() or delta_Ct() functions.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all genes.}

\item{group.study}{Character: name of study group (group of interest).}

\item{group.ref}{Character: name of reference group.}

\item{increment}{Numeric or "mean": the change of expression for which odds ratio values are calculated.
If increment = 1, odds ratio values regards for a one-unit increase in gene expression
(more suitable where data are not transformed using 2^-value formula). If increment = "mean", odds ratio values are
calculated for the situation where gene expression increases by mean of gene expression levels in all samples
(more suitable where data were transformed using 2^-value formula).}

\item{centerline}{Numeric: position of vertical centerline on the plot. Default to 1.}

\item{ci}{Numeric: confidence level used for computation of confidence interval. Default to 0.95.}

\item{p.adjust}{Logical: if TRUE, p values adjusted using a method provided in p.adjust.method parameter will be shown on the plot. Default to FALSE.}

\item{p.adjust.method}{Character: p value correction method for multiple testing, one of the "holm", "hochberg", "hommel",
"bonferroni", "BH" (default), "BY","fdr", or "none". See documentation for stats::p.adjust() function for details.}

\item{log.axis}{Logical: if TRUE, axis with odds ratio values will be in log10 scale. Default to FALSE.}

\item{x.axis.title}{Character: title of x axis. Default to "Gene".}

\item{y.axis.title}{Character: title of y axis. Default to "value".}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 10.}

\item{legend.title}{Character: title of legend. Default to "Group".}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.position}{Position of the legend, can be one of "top" (default), "right", "bottom", "left", or "none" (no legend).
See description for legend.position in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "OR_plot".}

\item{save.to.txt}{Logical: if TRUE, returned table with results will be saved to .txt file. Default to FALSE.}

\item{name.txt}{Character: name of saved .txt file, without ".txt" name of extension. Default to "OR_results".}
}
\value{
A list that contains an object with plot and data frame with calculated results. Created plot is also displayed on the graphic device.
}
\description{
This function performs logistic regression analysis, computes odd ratio values, and presents them graphically.
}
\examples{
library(tidyverse)
library(oddsratio)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("FGF23","ANGPT2","IL1A","CSF2","IL6"),
                       remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready,
                     ref = "GAPDH")
log.reg.results <- log_reg(data.dCt,
                           sel.Gene = c("ANGPT1","IL8", "VEGFB"),
                           group.study = "AAA",
                           group.ref = "Control",
                           increment = 1)

}
