% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_RIA.R
\encoding{UTF-8}
\name{save_RIA}
\alias{save_RIA}
\title{Export radiomics calculations of RIA image to csv}
\usage{
save_RIA(
  RIA_image,
  save_to = "C:/",
  save_name = "RIA_stat",
  group_name = "Case",
  stats = c("stat_fo", "stat_glcm_mean", "stat_glrlm_mean", "stat_geometry")
)
}
\arguments{
\item{RIA_image}{\emph{RIA_image} with calculated statistics.}

\item{save_to}{string, path of folder to save results to.}

\item{save_name}{string, path of folder to save results to.}

\item{group_name}{string, a ID defining which group the case belongs to.}

\item{stats}{string vector, identifing which slots to export}
}
\description{
Exports given slots of statistics from RIA_image. Names of slots have to be defined
which the user wishes to export using the \emph{stats} parameter. Using the \emph{group_name}
parameter the user can lable the cases with a group ID, for example "Case", which can be
used as a grouping variable for further analysis.
}
\references{
Márton KOLOSSVÁRY et al.
Radiomic Features Are Superior to Conventional Quantitative Computed Tomographic
Metrics to Identify Coronary Plaques With Napkin-Ring Sign
Circulation: Cardiovascular Imaging (2017).
DOI: 10.1161/circimaging.117.006843
\url{https://pubmed.ncbi.nlm.nih.gov/29233836/}

Márton KOLOSSVÁRY et al.
Cardiac Computed Tomography Radiomics: A Comprehensive Review on Radiomic Techniques.
Journal of Thoracic Imaging (2018).
DOI: 10.1097/RTI.0000000000000268
\url{https://pubmed.ncbi.nlm.nih.gov/28346329/}
}
