% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glcm_stat.R
\name{glcm_stat}
\alias{glcm_stat}
\title{Calculates GLCM-based statistics}
\usage{
glcm_stat(RIA_data_in, use_type = "single", use_orig = FALSE,
  use_slot = "glcm$es_8_111", save_name = NULL, verbose_in = TRUE)
}
\arguments{
\item{RIA_data_in}{\emph{RIA_image}, created by \code{\link[RIA]{load_dicom}}.}

\item{use_type}{string, can be \emph{"single"} which runs the function on a single image,
which is determined using \emph{"use_orig"} or \emph{"use_slot"}. \emph{"glcm"}
takes all datasets in the \emph{RIA_image$glcm} slot and runs the analysis on them.}

\item{use_orig}{logical, indicating to use image present in \emph{RIA_data$orig}.
If FALSE, the modified image will be used stored in \emph{RIA_data$modif}. However, GLCM matrices
are usually not present in either slots, therefore giving the slot name using \emph{use_slot} is advised.}

\item{use_slot}{string, name of slot where data wished to be used is. Use if the desired image
is not in the \emph{data$orig} or \emph{data$modif} slot of the \emph{RIA_image}. For example,
ig the desired dataset is in \emph{RIA_image$glcm$ep_4_111}, then \emph{use_slot} should be
\emph{glcm$ep_4_111}. The results are automatically saved. If the results are not saved to
the desired slot, then please use \emph{save_name} parameter. If the string contains "-" characters
use "`" before the last slot name, for example: \emph{glcm$`ep_4_-1-1-1`}}

\item{save_name}{string, indicating the name of subslot of \emph{$glcm} to save results to.
If left empty, then it will be automatically determined.}

\item{verbose_in}{logical, indicating whether to print detailed information.
Most prints can also be suppressed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing the statistical information.
}
\description{
Calculates GLCM-based statistics for given GLCM matrix.
}
\examples{
\dontrun{
#Discretize loaded image and then calculate GLCM statistics
RIA_image <- discretize(RIA_image, bins_in = 8, equal_prob = TRUE)
RIA_image <- glcm(RIA_image, use_orig = FALSE, use_slot = "discretized$ep_8",
off_right = 0, off_down = 1, off_z = 0)
RIA_image <- glcm_stat(RIA_image, use_orig = FALSE, use_slot = "glcm$ep_8_010")

#Batch calculation of GLCM-based statistics on all calculated GLCMs
RIA_image <- glcm_stat(RIA_image, use_type = "discretized")
}
}
