`PlotPowerBand` <-
function(HRVData,indexFreqAnalysis,normalized=FALSE,hr=FALSE,ymax=160000,ymaxratio=10,ymaxnorm=1,Tag=NULL,verbose=FALSE) {
# --------------------
# Plots power per band
# --------------------
#  indexFreqAnalysis: index of an existing frequency analysis to use
# 	normalized: plots normalized powers if TRUE
# 	hr: plots heart rate signal if TRUE
# 	ymax: maximum value for y axis (unnormalized plots)
# 	ymaxratio: maximum value for y axis in LF/HF band (normalized and unnormalized plots)
#	Tag -> Tags of episodes to include in the plot
#    "all" includes all types
#	Verbose -> TRUE for verbose mode

	if (verbose) {
		cat("** Plotting power per band **\n")
	}

   if ((length(HRVData$FreqAnalysis) < indexFreqAnalysis) || (indexFreqAnalysis<1) ) {
		stop("  --- Frequency analysis no.",indexFreqAnalysis,"not present!! ---\n    --- Quitting now!! ---\n")
   }

   if (!is.null(Tag) & is.null(HRVData$Episodes)) {
		stop("  --- Episodes not present!! ---\n    --- Quitting now!! ---\n")
   }
	
	if (is.null(HRVData$FreqAnalysis[[indexFreqAnalysis]]$ULF)) {
		cat("   --- ERROR: Power per band not present!! ---\n")
		return(HRVData)
	}
	 
	# normalization
	 if (normalized == TRUE) {
		HRVData$FreqAnalysis[[indexFreqAnalysis]]$ULF=(HRVData$FreqAnalysis[[indexFreqAnalysis]]$ULF-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$ULF))/(max(HRVData$FreqAnalysis[[indexFreqAnalysis]]$ULF)-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$ULF))
		HRVData$FreqAnalysis[[indexFreqAnalysis]]$VLF=(HRVData$FreqAnalysis[[indexFreqAnalysis]]$VLF-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$VLF))/(max(HRVData$FreqAnalysis[[indexFreqAnalysis]]$VLF)-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$VLF))
		HRVData$FreqAnalysis[[indexFreqAnalysis]]$LF=(HRVData$FreqAnalysis[[indexFreqAnalysis]]$LF-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$LF))/(max(HRVData$FreqAnalysis[[indexFreqAnalysis]]$LF)-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$LF))
		HRVData$FreqAnalysis[[indexFreqAnalysis]]$HF=(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HF-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HF))/(max(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HF)-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HF))
		# HRVData$FreqAnalysis[[indexFreqAnalysis]]$LFHF=(HRVData$FreqAnalysis[[indexFreqAnalysis]]$LFHF-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$LFHF))/(max(HRVData$FreqAnalysis[[indexFreqAnalysis]]$LFHF)-min(HRVData$FreqAnalysis[[indexFreqAnalysis]]$LFHF))
		if (verbose) {
			cat("   Power per band normalized\n")
 		}
	}
			
	# For normalized plots, axis y is in the interval (0-ymax)
	if (normalized == FALSE) {
		ymaxv=c(0,ymax)
	}
	else {
		ymaxv=c(0,ymaxnorm)
	}
	
	ymaxratiov=c(0,ymaxratio)
	
	if (hr)
		numfilas=6
	else
		numfilas=5

	# lframes is the number of frames for plotting power per band
	lframes=length(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HRV)

   # Episodes
   if (!is.null(Tag)) {

       if (Tag[1]=="all") {
         Tag=levels(HRVData$Episodes$Type)
      }

      if (verbose) {
         cat("   Episodes in plot:",Tag,"\n")
      }

      # Data for representing episodes
      EpisodesAuxLeft=HRVData$Episodes$InitTime[HRVData$Episodes$Type %in% Tag]
      EpisodesAuxLeftFrame=EpisodesAuxLeft*lframes/(tail(HRVData$Beat$Time,1)-head(HRVData$Beat$Time,1)) # Beg of episodes (frames)
      EpisodesAuxRight=HRVData$Episodes$InitTime[HRVData$Episodes$Type %in% Tag] + 
         HRVData$Episodes$Duration[HRVData$Episodes$Type %in% Tag]
      EpisodesAuxRightFrame=EpisodesAuxRight*lframes/(tail(HRVData$Beat$Time,1)-head(HRVData$Beat$Time,1)) # Beg of episodes (frames)
      EpisodesAuxType=HRVData$Episodes$Type[HRVData$Episodes$Type %in% Tag]
      cat("   No of episodes:",length(EpisodesAuxLeft),"\n")
      
      Pal=rainbow(length(Tag))
      Bor=Pal[match(EpisodesAuxType,Tag)]


      EpisodesLeft=HRVData$Episodes$InitTime # Beg of episodes (seconds)
      EpisodesLeftFrame=EpisodesLeft*lframes/(tail(HRVData$Beat$Time,1)-head(HRVData$Beat$Time,1)) # Beg of episodes (frames)
      EpisodesRight=HRVData$Episodes$InitTime+HRVData$Episodes$Duration # Beg of episodes (seconds)
      EpisodesRightFrame=EpisodesRight*lframes/(tail(HRVData$Beat$Time,1)-head(HRVData$Beat$Time,1)) # Beg of episodes (frames)
   }

	par(mfrow=c(numfilas,1),omi=c(0.1,0,0.1,0),mai=c(0.5,0.5,0.9,0.1),mar=c(3,5,1,2),oma=c(1,1,2,1))
	
	mfg=c(1,1,numfilas,1)
	plot(seq(from=0,to=lframes,length.out=length(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HRV)),
			HRVData$FreqAnalysis[[indexFreqAnalysis]]$LFHF,type='l',xlab="",ylab="LF/HF",ylim=ymaxratiov)
   if (!is.null(Tag)) {
      rect(EpisodesAuxLeftFrame,rep(ymaxratiov[1],times=length(EpisodesAuxLeft)),
         EpisodesAuxRightFrame,rep(ymaxratiov[2],times=length(EpisodesAuxLeft)),
         border=Bor)
      par(xpd=NA) 
      legend(lframes/2,ymaxratiov[2],legend=Tag,fill=Pal,cex=0.9,ncol=length(Tag),xjust=0.5,yjust=0,bty="n")
   }
	if (verbose) {
		cat("   Plotted LF/HF\n")
	}

	mfg=c(1,2,numfilas,1)
	plot(seq(from=0,to=lframes,length.out=length(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HRV)),
			HRVData$FreqAnalysis[[indexFreqAnalysis]]$ULF,type='l',xlab="",ylab="ULF",ylim=ymaxv)
   if (!is.null(Tag)) {
      rect(EpisodesAuxLeftFrame,rep(ymaxv[1],times=length(EpisodesAuxLeft)),
         EpisodesAuxRightFrame,rep(ymaxv[2],times=length(EpisodesAuxLeft)),
         border=Bor)
   }
	if (verbose) {
		cat("   Plotted ULF\n")
	}

	mfg=c(1,3,numfilas,1)
	plot(seq(from=0,to=lframes,length.out=length(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HRV)),
			HRVData$FreqAnalysis[[indexFreqAnalysis]]$VLF,type='l',xlab="",ylab="VLF",ylim=ymaxv)
   if (!is.null(Tag)) {
      rect(EpisodesAuxLeftFrame,rep(ymaxv[1],times=length(EpisodesAuxLeft)),
         EpisodesAuxRightFrame,rep(ymaxv[2],times=length(EpisodesAuxLeft)),
         border=Bor)
   }
	if (verbose) {
		cat("   Plotted VLF\n")
	}

	mfg=c(1,4,numfilas,1)
	plot(seq(from=0,to=lframes,length.out=length(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HRV)),
			HRVData$FreqAnalysis[[indexFreqAnalysis]]$LF,type='l',xlab="",ylab="LF",ylim=ymaxv)
   if (!is.null(Tag)) {
      rect(EpisodesAuxLeftFrame,rep(ymaxv[1],times=length(EpisodesAuxLeft)),
         EpisodesAuxRightFrame,rep(ymaxv[2],times=length(EpisodesAuxLeft)),
         border=Bor)
   }
	if (verbose) {
		cat("   Plotted LF\n")
	}

	mfg=c(1,5,numfilas,1)
	texto4="No. of frames"
	plot(seq(from=0,to=lframes,length.out=length(HRVData$FreqAnalysis[[indexFreqAnalysis]]$HRV)),
			HRVData$FreqAnalysis[[indexFreqAnalysis]]$HF,type='l',xlab=texto4,ylab="HF",ylim=ymaxv)
   if (!is.null(Tag)) {
      rect(EpisodesAuxLeftFrame,rep(ymaxv[1],times=length(EpisodesAuxLeft)),
         EpisodesAuxRightFrame,rep(ymaxv[2],times=length(EpisodesAuxLeft)),
         border=Bor)
   }
	if (verbose) {
		cat("   Plotted HF\n")
	} 

	if (numfilas==6) {
		mfg=c(1,6,numfilas,1)
		# lsecs is the duration of the record in seconds for plotting heart rate signal
		lsecs=tail(HRVData$Beat$Time,1)-head(HRVData$Beat$Time,1)
		plot(seq(from=0,to=lsecs,length.out=length(HRVData$HR)),
				 HRVData$HR,type='l',xlab="Time (sec.)",ylab="HRV")
		if (verbose) {
			cat("   Plotted HRV\n")
		}

      if (!is.null(Tag)) {
         rect(EpisodesAuxLeft,rep(min(HRVData$HR),times=length(EpisodesAuxLeft)),
            EpisodesAuxRight,rep(max(HRVData$HR),times=length(EpisodesAuxLeft)),
               border=Bor)
      }
	}

   if (verbose & !is.null(Tag)) {
      cat("   Episodes plotted\n")
   }
	
	if ((normalized == TRUE) && (numfilas == 6)) 
		title(main="Normalized power bands of HRV and Heart Rate Signal",outer=TRUE)
	else if ((normalized == FALSE) && (numfilas == 6))
		title(main="Power bands of HRV and Heart Rate Signal",outer=TRUE)
	else if ((normalized == TRUE) && (numfilas != 6))
		title(main="Normalized power bands of HRV",outer=TRUE)
	else
		title(main="Power bands of HRV",outer=TRUE)
	
	if (verbose) {
		cat("   Power per band plotted\n")
	}	 
}

