% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileHandlingFormats.R
\name{fLoadFluxnet15}
\alias{fLoadFluxnet15}
\title{Read a file in the format of Fluxnet 2015 release}
\usage{
fLoadFluxnet15(
  file_path,
  additional_columns = character(0),
  colname_NEE = "NEE",
  ...
)
}
\arguments{
\item{file_path}{scalar string: the path to the csv file}

\item{additional_columns}{character vector of columns to
read in addition of standard columns of \code{\link{read_from_fluxnet15}}.
Can be a character vector or a object return by \code{\link{cols}}}

\item{colname_NEE}{name (scalar string) of column that reports NEE observations}

\item{...}{further arguments to \code{\link{read_csv}}}
}
\description{
Assigns default units to the columns and keeps variable name attributes
as in original file.
}
\examples{
  ds_fn15 <- Example_DETha98 \%>\%
     fConvertTimeToPosix('YDH',Year = 'Year',Day = 'DoY', Hour = 'Hour') \%>\%
     dplyr::mutate(
        TIMESTAMP_END = POSIXctToBerkeleyJulianDate(DateTime),
        season = factor(199801)
     ) \%>\%
     dplyr::rename(SW_IN = "Rg", TA = "Tair", USTAR = "Ustar") \%>\%
     dplyr::select(dplyr::one_of(c(
       "TIMESTAMP_END","NEE","SW_IN","TA","VPD","USTAR","season")))
  head(ds_fn15)
  fname <- tempfile()
  readr::write_csv(ds_fn15, fname)

  # standard columns are renamed to REddyProc defaults
  ds_eproc <- fLoadFluxnet15(fname)
  head(ds_eproc)
  EProc <- sEddyProc$new("DE-Tha", ds_eproc)
  head(EProc$sExportData())

  # Additional columns can be specified, e.g. factor column season
  ds_eproc <- fLoadFluxnet15(fname,
    additional_columns = readr::cols(season = readr::col_factor()))
  head(ds_eproc)
  EProc <- sEddyProc$new("DE-Tha", ds_eproc,
    c("NEE", "Rg", "Tair", "VPD", "Ustar","season"),
    ColNamesNonNumeric = "season"
    )
  head(EProc$sExportData())
}
