% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z2S.R
\name{z2S}
\alias{z2S}
\title{Compute the robust effect size index estimate from Z statistic}
\usage{
z2S(z, n)
}
\arguments{
\item{z}{The Z statistic for the parameter of interest.}

\item{n}{Number of independent samples.}
}
\value{
Returns a scalar or vector argument of the the robust effect size index estimate.
}
\description{
This function computes the robust effect size index from Vandekar, Rao, & Blume (2020).
Vector arguments are accepted. If different length arguments are passed they are dealt with in the usual way of R.
}
\details{
This function computes S, the RESI, from a Z statistic using the default
formula. There is another function, \code{\link{z2S_alt}}, that uses an alternative
formula. This function's formula is derived by solving the expected value of the
Z statistic for S. It is unbiased and consistent.

The formula for this conversion is:

\eqn{ S = Z/\sqrt(n)}
}
\examples{
# to obtain example z values, first fit a glm
mod = glm(charges ~ region * age + bmi + sex, data = RESI::insurance)
# run coeftest to get z values using a robust variance-covariance function
zs = lmtest::coeftest(mod, vcov. = sandwich::vcovHC)[,'z value']

# get RESI estimates
z2S(zs, n = nrow(RESI::insurance))
}
