% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_life_expectancy.R
\name{plot_life_expectancy}
\alias{plot_life_expectancy}
\title{Plot life expectancy of household members}
\usage{
plot_life_expectancy(household)
}
\arguments{
\item{household}{An R6 object of class \code{Household}.}
}
\value{
A \code{ggplot} object.
}
\description{
Probability of dying at a given age is plotted for each member
of a household.
Also for each member the life expectancy is shown
as dashed vertical line.
}
\examples{
hm1 <- 
 HouseholdMember$new(
   name       = "member1",
   birth_date = "1955-01-01",
   mode       = 88,
   dispersion = 10.65
 )
hm2 <- 
 HouseholdMember$new(
   name       = "member2",
   birth_date = "1965-01-01",
   mode       = 91,
   dispersion = 8.88
 )
household <- Household$new()
household$add_member(hm1)
household$add_member(hm2)

plot_life_expectancy(household = household)
}
